/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.c.pre.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.c.pre.CpreSyntaxException;
import net.morilib.c.pre.parser.CpreFloatToken;
import net.morilib.c.pre.parser.CpreIntegerToken;
import net.morilib.c.pre.parser.CpreOperator;
import net.morilib.c.pre.parser.CpreRelop1;
import net.morilib.c.pre.parser.CpreRelop2;
import net.morilib.c.pre.parser.CpreSymbol;
import net.morilib.c.pre.parser.CpreToken;

public final class CpreLexer {
    private static final Map<Integer, CpreToken> OP1;
    static final String ERR001 = "more than two characters is not allowed";
    private CpreToken token;
    private PushbackReader reader;
    private int headchr = 0;
    private int lineno;

    static {
        HashMap<Integer, CpreOperator> o = new HashMap<Integer, CpreOperator>();
        o.put(63, CpreOperator.TRI1);
        o.put(58, CpreOperator.TRI2);
        o.put(126, CpreOperator.B_NOT);
        o.put(40, CpreOperator.LPAREN);
        o.put(41, CpreOperator.RPAREN);
        o.put(44, CpreOperator.COMMA);
        OP1 = Collections.unmodifiableMap(o);
    }

    public CpreLexer(int lineno, Reader rd) throws IOException {
        this.reader = new PushbackReader(rd);
        this.headchr = this.reader.read();
        if (this.headchr >= 0) {
            this.reader.unread(this.headchr);
        }
        this.lineno = lineno;
        this.token = CpreLexer.getToken(lineno, this.reader);
    }

    public CpreToken getToken() {
        return this.token;
    }

    public CpreToken nextToken() throws IOException {
        if (!this.token.equals(CpreToken.ENDMARKER)) {
            this.headchr = this.reader.read();
            if (this.headchr >= 0) {
                this.reader.unread(this.headchr);
            }
            this.token = CpreLexer.getToken(this.lineno, this.reader);
        }
        return this.token;
    }

    public CpreToken eatToken(CpreToken t) throws IOException {
        if (!this.token.equals(t)) {
            throw new CpreSyntaxException(this.lineno, t, this.token);
        }
        return this.nextToken();
    }

    public CpreToken eatTokenOpt(CpreToken t) throws IOException {
        if (this.token.equals(t)) {
            return this.nextToken();
        }
        return this.token;
    }

    public int getLineNumber() {
        return this.lineno;
    }

    private static int rde(int ln, PushbackReader rd) throws IOException {
        int c = rd.read();
        if (c < 0) {
            throw new CpreSyntaxException(ln, "unexpected EOF");
        }
        return c;
    }

    private static int skipws(PushbackReader rd) throws IOException {
        int c;
        boolean cm = false;
        while ((c = rd.read()) >= 0) {
            if (cm) {
                cm = c != 10;
                continue;
            }
            if (c == 35) {
                cm = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        if (c < 0) {
            throw new EndException();
        }
        return c;
    }

    private static int getoct1(int ln, PushbackReader rd) throws IOException {
        int c = CpreLexer.rde(ln, rd);
        if (c < 48 || c > 55) {
            throw new CpreSyntaxException(ln, "octal number required");
        }
        return c - 48;
    }

    private static int getoct(int ln, PushbackReader rd) throws IOException {
        return CpreLexer.getoct1(ln, rd) * 64 + CpreLexer.getoct1(ln, rd) * 8 + CpreLexer.getoct1(ln, rd);
    }

    private static int gethex1(int ln, PushbackReader rd) throws IOException {
        int c = CpreLexer.rde(ln, rd);
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        throw new CpreSyntaxException(ln, "hexadecimal number required");
    }

    private static int gethex(int ln, PushbackReader rd) throws IOException {
        return CpreLexer.gethex1(ln, rd) * 4096 + CpreLexer.gethex1(ln, rd) * 256 + CpreLexer.gethex1(ln, rd) * 16 + CpreLexer.gethex1(ln, rd);
    }

    private static int gethexc(int ln, PushbackReader rd) throws IOException {
        return CpreLexer.gethex1(ln, rd) * 16 + CpreLexer.gethex1(ln, rd);
    }

    static CpreToken _getToken(int ln, PushbackReader rd) throws IOException {
        StringBuffer b1 = new StringBuffer();
        CpreIntegerToken c0 = null;
        St1 stat = St1.INIT;
        block36: while (true) {
            switch (stat) {
                case INIT: {
                    int c = CpreLexer.skipws(rd);
                    if (c == 60) {
                        stat = St1.LT;
                        continue block36;
                    }
                    if (c == 62) {
                        stat = St1.GT;
                        continue block36;
                    }
                    if (c == 61) {
                        stat = St1.EQ;
                        continue block36;
                    }
                    if (c == 33) {
                        stat = St1.EX;
                        continue block36;
                    }
                    if (c == 38) {
                        stat = St1.AND;
                        continue block36;
                    }
                    if (c == 124) {
                        stat = St1.OR;
                        continue block36;
                    }
                    if (c == 43) {
                        stat = St1.PLUS;
                        continue block36;
                    }
                    if (c == 45) {
                        stat = St1.MINUS;
                        continue block36;
                    }
                    if (c == 42) {
                        stat = St1.ASTERISK;
                        continue block36;
                    }
                    if (c == 47) {
                        stat = St1.SLASH;
                        continue block36;
                    }
                    if (c == 37) {
                        stat = St1.PERCENT;
                        continue block36;
                    }
                    if (c == 94) {
                        stat = St1.CARET;
                        continue block36;
                    }
                    if (c == 39) {
                        stat = St1.CH1;
                        continue block36;
                    }
                    if (OP1.containsKey(c)) {
                        return OP1.get(c);
                    }
                    if (c == 48) {
                        stat = St1.ZERO;
                        continue block36;
                    }
                    if (c >= 49 && c <= 57) {
                        b1 = new StringBuffer().append((char)c);
                        stat = St1.NUMBER;
                        continue block36;
                    }
                    if (!(c >= 97 && c <= 122 || c >= 65 && c <= 122) && c != 95) continue block36;
                    b1 = new StringBuffer().appendCodePoint(c);
                    stat = St1.SYMBOL;
                    continue block36;
                }
                case LT: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreRelop1.LT;
                    }
                    if (c == 61) {
                        return CpreRelop1.LE;
                    }
                    if (c == 60) {
                        return CpreOperator.SHIFTL;
                    }
                    rd.unread(c);
                    return CpreRelop1.LT;
                }
                case GT: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreRelop1.GT;
                    }
                    if (c == 61) {
                        return CpreRelop1.GE;
                    }
                    if (c == 62) {
                        return CpreOperator.SHIFTR;
                    }
                    rd.unread(c);
                    return CpreRelop1.GT;
                }
                case EQ: {
                    int c = rd.read();
                    if (c < 0) {
                        throw new CpreSyntaxException(ln, "unexpected EOF");
                    }
                    if (c == 61) {
                        return CpreRelop2.EQ;
                    }
                    throw new CpreSyntaxException(ln, "assignment operator is not valid");
                }
                case EX: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.L_NOT;
                    }
                    if (c == 61) {
                        return CpreRelop2.NE;
                    }
                    rd.unread(c);
                    return CpreOperator.L_NOT;
                }
                case AND: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.B_AND;
                    }
                    if (c == 38) {
                        return CpreOperator.L_AND;
                    }
                    rd.unread(c);
                    return CpreOperator.B_AND;
                }
                case OR: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.B_OR;
                    }
                    if (c == 124) {
                        return CpreOperator.L_OR;
                    }
                    rd.unread(c);
                    return CpreOperator.B_OR;
                }
                case PLUS: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.ADD;
                    }
                    rd.unread(c);
                    return CpreOperator.ADD;
                }
                case MINUS: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.SUB;
                    }
                    rd.unread(c);
                    return CpreOperator.SUB;
                }
                case ASTERISK: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.MUL;
                    }
                    rd.unread(c);
                    return CpreOperator.MUL;
                }
                case SLASH: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.DIV;
                    }
                    rd.unread(c);
                    return CpreOperator.DIV;
                }
                case PERCENT: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.MOD;
                    }
                    rd.unread(c);
                    return CpreOperator.MOD;
                }
                case CARET: {
                    int c = rd.read();
                    if (c < 0) {
                        return CpreOperator.B_XOR;
                    }
                    rd.unread(c);
                    return CpreOperator.B_XOR;
                }
                case ZERO: {
                    int c = rd.read();
                    if (c < 0) {
                        return new CpreIntegerToken("0", 10);
                    }
                    if (c == 120) {
                        stat = St1.NUMBER_HEX;
                        continue block36;
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.NUMBER_OCT;
                        continue block36;
                    }
                    rd.unread(c);
                    return new CpreIntegerToken("0", 10);
                }
                case NUMBER: {
                    int c = rd.read();
                    if (c < 0) {
                        return new CpreIntegerToken(b1.toString(), 10);
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block36;
                    }
                    if (c == 46) {
                        b1.append((char)c);
                        stat = St1.FLOAT1;
                        continue block36;
                    }
                    if (c == 101 || c == 69) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E1;
                        continue block36;
                    }
                    rd.unread(c);
                    return new CpreIntegerToken(b1.toString(), 10);
                }
                case NUMBER_OCT: {
                    int c = rd.read();
                    if (c < 0) {
                        return new CpreIntegerToken(b1.toString(), 8);
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block36;
                    }
                    rd.unread(c);
                    return new CpreIntegerToken(b1.toString(), 8);
                }
                case NUMBER_HEX: {
                    int c = rd.read();
                    if (c < 0) {
                        return new CpreIntegerToken(b1.toString(), 16);
                    }
                    if (c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
                        b1.append((char)c);
                        continue block36;
                    }
                    rd.unread(c);
                    return new CpreIntegerToken(b1.toString(), 16);
                }
                case FLOAT1: {
                    int c = CpreLexer.rde(ln, rd);
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT2;
                        continue block36;
                    }
                    throw new CpreSyntaxException(ln, "number required");
                }
                case FLOAT2: {
                    int c = rd.read();
                    if (c < 0) {
                        return new CpreFloatToken(b1.toString());
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block36;
                    }
                    if (c == 101 || c == 69) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E1;
                        continue block36;
                    }
                    rd.unread(c);
                    return new CpreFloatToken(b1.toString());
                }
                case FLOAT_E1: {
                    int c = CpreLexer.rde(ln, rd);
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E3;
                        continue block36;
                    }
                    if (c == 43 || c == 45) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E2;
                        continue block36;
                    }
                    throw new CpreSyntaxException(ln, "number required");
                }
                case FLOAT_E2: {
                    int c = CpreLexer.rde(ln, rd);
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E3;
                        continue block36;
                    }
                    throw new CpreSyntaxException(ln, "number required");
                }
                case FLOAT_E3: {
                    int c = rd.read();
                    if (c < 0) {
                        return new CpreFloatToken(b1.toString());
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block36;
                    }
                    rd.unread(c);
                    return new CpreFloatToken(b1.toString());
                }
                case SYMBOL: {
                    int c = rd.read();
                    if (c >= 97 && c <= 122 || c >= 65 && c <= 122 || c >= 48 && c <= 57 || c == 95) {
                        b1.appendCodePoint(c);
                        continue block36;
                    }
                    if (b1.toString().equals("defined")) {
                        rd.unread(c);
                        return CpreOperator.DEFINED;
                    }
                    rd.unread(c);
                    return CpreSymbol.getInstance(b1.toString());
                }
                case CH1: {
                    int c = rd.read();
                    if (c == 92) {
                        stat = St1.CH2;
                        continue block36;
                    }
                    stat = St1.CH3;
                    c0 = new CpreIntegerToken(c);
                    continue block36;
                }
                case CH2: {
                    int c = rd.read();
                    switch (c) {
                        case 110: {
                            c0 = new CpreIntegerToken(10L);
                            break;
                        }
                        case 98: {
                            c0 = new CpreIntegerToken(8L);
                            break;
                        }
                        case 114: {
                            c0 = new CpreIntegerToken(13L);
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            rd.unread((char)c);
                            c0 = new CpreIntegerToken(CpreLexer.getoct(ln, rd));
                            break;
                        }
                        case 120: {
                            c0 = new CpreIntegerToken(CpreLexer.gethexc(ln, rd));
                            break;
                        }
                        case 117: {
                            c0 = new CpreIntegerToken(CpreLexer.gethex(ln, rd));
                            break;
                        }
                        default: {
                            c0 = new CpreIntegerToken(c);
                        }
                    }
                    stat = St1.CH3;
                    continue block36;
                }
                case CH3: {
                    int c = rd.read();
                    if (c != 39) {
                        throw new CpreSyntaxException(ln, ERR001);
                    }
                    return c0;
                }
            }
        }
    }

    public static CpreToken getToken(int lineno, PushbackReader rd) throws IOException {
        try {
            return CpreLexer._getToken(lineno, rd);
        }
        catch (EndException e) {
            return CpreToken.ENDMARKER;
        }
    }

    private static class EndException
    extends RuntimeException {
        private EndException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum St1 {
        INIT,
        LT,
        GT,
        EQ,
        EX,
        AND,
        OR,
        PLUS,
        MINUS,
        ASTERISK,
        SLASH,
        CARET,
        PERCENT,
        ZERO,
        NUMBER,
        NUMBER_OCT,
        NUMBER_HEX,
        FLOAT1,
        FLOAT2,
        FLOAT_E1,
        FLOAT_E2,
        FLOAT_E3,
        SYMBOL,
        CH1,
        CH2,
        CH3;

    }
}

