/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

/**
 * 関数s.insertの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class SInsert extends AwkTernaryArgs {

	protected SInsert() {
		super("insert");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		StringBuffer a = new StringBuffer(a1.toString(ns));
		String b = a3.toString(ns);
		int c;

		if((c = a2.toIntExact()) < 1) {
			throw new AwkRuntimeException("natural number required");
		} else if(c > a.length() + 1) {
			throw new AwkRuntimeException("index out of bounds");
		} else {
			a.insert(c - 1, b);
		}
		return AwkString.valueOf(a.toString());
	}

}
