/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.a;

import java.math.BigInteger;
import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class ArrayIota
extends AwkBinaryArgs {
    private static final BigInteger P1 = BigInteger.ONE;
    private static final BigInteger M1 = BigInteger.ONE.negate();

    protected ArrayIota() {
        super("iota");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1, AwkValue a2) {
        BigInteger a = a1.toInteger();
        BigInteger b = a2.toInteger();
        AwkArray r = new AwkArray();
        if (a.compareTo(b) < 0) {
            BigInteger i = a;
            while (i.compareTo(b) <= 0) {
                r.putArray(i.subtract(a).add(P1).toString(), AwkInteger.valueOf(i));
                i = i.add(P1);
            }
        } else if (a.compareTo(b) > 0) {
            BigInteger i = a;
            while (i.compareTo(b) >= 0) {
                r.putArray(i.subtract(a).negate().add(P1).toString(), AwkInteger.valueOf(i));
                i = i.add(M1);
            }
        } else {
            r.putArray("1", AwkInteger.valueOf(a));
        }
        return r;
    }
}

