/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.dist.AbstractContinuousDistribution;
import net.morilib.awk.stat.special.Beta;

public class BetaDistribution
extends AbstractContinuousDistribution {
    private double alpha;
    private double beta;

    public BetaDistribution(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.alpha = alpha;
        this.beta = beta;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public boolean isInSupport(double n) {
        return n >= 0.0 && n <= 1.0;
    }

    public double supportInfimum() {
        return 0.0;
    }

    public double supportSupremum() {
        return 1.0;
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        double r = Beta.I(x, this.alpha, this.beta);
        double a = Beta.I(x - 1.0E-15, this.alpha, this.beta);
        double b = Beta.I(x + 1.0E-15, this.alpha, this.beta);
        if (Double.isNaN(r) || a < r && r > b || a > r && r < b) {
            return (a + b) / 2.0;
        }
        return r == 0.0 && x >= 0.9 ? 1.0 : r;
    }

    public double expectedValue() {
        return this.alpha / (this.alpha + this.beta);
    }

    public double kurtosis() {
        double ab1 = this.alpha + this.beta + 1.0;
        double ab2 = this.alpha + this.beta + 2.0;
        double ab3 = this.alpha + this.beta + 3.0;
        double abs = this.alpha - this.beta;
        double x = 6.0 * (abs * abs * ab1 - this.alpha * this.beta * ab2);
        return x /= this.alpha * this.beta * ab2 * ab3;
    }

    public double mode() {
        return Double.NaN;
    }

    public double skewness() {
        double ab1 = this.alpha + this.beta + 1.0;
        double ab2 = this.alpha + this.beta + 2.0;
        double bas = this.beta - this.alpha;
        double x = 2.0 * bas * Math.sqrt(ab1);
        return x /= ab2 * Math.sqrt(this.alpha * this.beta);
    }

    public double variance() {
        double ab = this.alpha + this.beta;
        double ab1 = this.alpha + this.beta + 1.0;
        return this.alpha * this.beta / ab / ab / ab1;
    }

    public double f(double x) {
        if (x <= 0.0 || x >= 1.0) {
            return 0.0;
        }
        double z = Math.log(x);
        double w = Math.log(1.0 - x);
        double l = (this.alpha - 1.0) * z + (this.beta - 1.0) * w;
        return Math.exp(l -= Beta.logBeta(this.alpha, this.beta));
    }
}

