/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.strftime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public final class StrftimeWareki {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy/MM/dd");
    private static final Date EPOCH_HEISEI = StrftimeWareki.fmt("1989/01/08");
    private static final Date EPOCH_SHOWA = StrftimeWareki.fmt("1926/12/25");
    private static final Date EPOCH_TAISHO = StrftimeWareki.fmt("1912/07/30");
    private static final Date EPOCH_MEIJI = StrftimeWareki.fmt("1868/10/23");
    private static final Date[] EPOCHS;
    private static final String[] EPOCH_NAMES;
    private static final String[] EPOCH_SHORT_NAMES;
    public static StrftimeWareki LONG;
    public static StrftimeWareki SHORT;
    private String[] names;

    static {
        Date[] dateArray = new Date[5];
        dateArray[0] = EPOCH_HEISEI;
        dateArray[1] = EPOCH_SHOWA;
        dateArray[2] = EPOCH_TAISHO;
        dateArray[3] = EPOCH_MEIJI;
        EPOCHS = dateArray;
        EPOCH_NAMES = new String[]{"\u5e73\u6210", "\u662d\u548c", "\u5927\u6b63", "\u660e\u6cbb", "\u660e\u6cbb\u4ee5\u524d"};
        EPOCH_SHORT_NAMES = new String[]{"H", "S", "T", "M"};
        LONG = new StrftimeWareki(EPOCH_NAMES);
        SHORT = new StrftimeWareki(EPOCH_SHORT_NAMES);
    }

    StrftimeWareki(String[] names) {
        this.names = names;
    }

    private static Date fmt(String s) {
        try {
            return FMT.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEra(Date date) {
        int i = 0;
        while (i < EPOCHS.length) {
            if (EPOCHS[i] == null || !date.before(EPOCHS[i])) {
                return i < this.names.length ? this.names[i] : "?";
            }
            ++i;
        }
        return "?";
    }

    public int getYear(Date date) {
        int i = 0;
        while (i < EPOCHS.length) {
            if (EPOCHS[i] == null) {
                return 0;
            }
            if (!date.before(EPOCHS[i])) {
                GregorianCalendar c = new GregorianCalendar();
                GregorianCalendar d = new GregorianCalendar();
                c.setTime(date);
                d.setTime(EPOCHS[i]);
                return c.get(1) - d.get(1) + 1;
            }
            ++i;
        }
        return 0;
    }
}

