/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.random;

import net.morilib.awk.random.MersenneTwisterRandomState;
import net.morilib.awk.random.RandomSource;
import net.morilib.awk.random.RandomState;

public class MersenneTwisterRandom
implements RandomSource {
    private static final int N = 624;
    private static final int M = 397;
    private static final long MATRIX_A = 2567483615L;
    private static final long UPPER_MASK = 0x80000000L;
    private static final long LOWER_MASK = Integer.MAX_VALUE;
    private static long[] mag01;
    private long[] mt = new long[624];
    private int mti = 625;
    private long seed;

    static {
        long[] lArray = new long[2];
        lArray[1] = 2567483615L;
        mag01 = lArray;
    }

    MersenneTwisterRandom() {
    }

    public MersenneTwisterRandom(long s) {
        this.nextUnsignedInt();
        this.init(s);
    }

    public static MersenneTwisterRandom getInstance() {
        MersenneTwisterRandom r = new MersenneTwisterRandom();
        r.nextUnsignedInt();
        r.init((long)(Math.random() * 2.147483647E9) + 1L);
        return r;
    }

    public void init(long s) {
        this.mt[0] = s & 0xFFFFFFFFL;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + (long)this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFFL;
        }
        this.seed = s;
    }

    protected void initByArray(long[] initKey) {
        this.init(19650218L);
        int i = 1;
        int j = 0;
        int k = 624 > initKey.length ? 624 : initKey.length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525L) + initKey[j] + (long)j;
            int n = i++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFFL;
            ++j;
            if (i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= initKey.length) {
                j = 0;
            }
            --k;
        }
        k = 623;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941L) - (long)i;
            int n = i++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFFL;
            if (i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            --k;
        }
        this.mt[0] = 0x80000000L;
    }

    public long nextUnsignedInt() {
        long y;
        if (this.mti >= 624) {
            if (this.mti == 625) {
                this.init(5489L);
            }
            int kk = 0;
            while (kk < 227) {
                y = this.mt[kk] & 0x80000000L | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ mag01[(int)(y & 1L)];
                ++kk;
            }
            while (kk < 623) {
                y = this.mt[kk] & 0x80000000L | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ mag01[(int)(y & 1L)];
                ++kk;
            }
            y = this.mt[623] & 0x80000000L | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ mag01[(int)(y & 1L)];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >>> 18;
        return y;
    }

    public int nextInt() {
        return (int)this.nextUnsignedInt();
    }

    public double nextDouble1Closed() {
        return (double)this.nextUnsignedInt() * 2.3283064370807974E-10;
    }

    public double nextDouble1RightOpen() {
        return (double)this.nextUnsignedInt() * 2.3283064365386963E-10;
    }

    public double nextDouble1Open() {
        return ((double)this.nextUnsignedInt() + 0.5) * 2.3283064365386963E-10;
    }

    public MersenneTwisterRandomState getState() {
        MersenneTwisterRandomState s = new MersenneTwisterRandomState();
        s.mti = this.mti;
        s.mt = new long[624];
        System.arraycopy(this.mt, 0, s.mt, 0, 624);
        s.seed = this.seed;
        return s;
    }

    public void setState(RandomState s) {
        if (!(s instanceof MersenneTwisterRandomState)) {
            throw new ClassCastException();
        }
        MersenneTwisterRandomState t = (MersenneTwisterRandomState)s;
        this.mti = t.mti;
        System.arraycopy(t.mt, 0, this.mt, 0, 624);
        this.seed = t.seed;
    }

    public long getSeed() {
        return this.seed;
    }
}

