/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import java.math.BigInteger;
import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;
import net.morilib.awk.stat.special.Beta;
import net.morilib.awk.stat.special.Gamma;

public class NegativeBinomialDistribution
extends AbstractDiscreteDistribution {
    private BigInteger size;
    private double succeed;

    public NegativeBinomialDistribution(BigInteger size, double succeed) {
        if (size == null) {
            throw new NullPointerException();
        }
        if (size.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        if (succeed < 0.0 || succeed > 1.0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.succeed = succeed;
    }

    public static NegativeBinomialDistribution geometric(double succeed) {
        return new NegativeBinomialDistribution(BigInteger.ONE, succeed);
    }

    public BigInteger getSize() {
        return this.size;
    }

    public double getSucceed() {
        return this.succeed;
    }

    public double f(int x) {
        double n = this.size.doubleValue();
        double p = 1.0 - this.succeed;
        double k = x;
        if (!this.isInSupport(x)) {
            return 0.0;
        }
        double lb = Gamma.lnGamma(k + n);
        double lp = k * Math.log(p) + n * Math.log(1.0 - p);
        return Math.exp((lb -= Gamma.lnGamma(k + 1.0) + Gamma.lnGamma(n)) + lp);
    }

    public double cdf(double k) {
        double n = this.size.doubleValue();
        double p = 1.0 - this.succeed;
        if (k < 0.0) {
            return 0.0;
        }
        double l = Math.floor(k);
        double r = Beta.I(p, l + 1.0, n);
        double a = Beta.I(p - 0.001, l + 1.0, n);
        double b = Beta.I(p + 0.001, l + 1.0, n);
        if (Double.isNaN(r) || a < r && r > b || a > r && r < b) {
            return 1.0 - (a + b) / 2.0;
        }
        return 1.0 - r;
    }

    public boolean isInSupport(int n) {
        return n >= 0;
    }

    public double expectedValue() {
        return this.succeed * this.size.doubleValue() / this.succeed;
    }

    public double variance() {
        double fa = this.succeed;
        return this.succeed * this.size.doubleValue() / fa / fa;
    }

    public double mode() {
        double n = this.size.doubleValue();
        double p = 1.0 - this.succeed;
        return Math.floor(p * (n - 1.0) / (1.0 - p));
    }

    public double skewness() {
        double n = this.size.doubleValue();
        double p = 1.0 - this.succeed;
        return (1.0 + p) / Math.sqrt(p * n);
    }

    public double kurtosis() {
        double n = this.size.doubleValue();
        double f = this.succeed;
        double p = 1.0 - f;
        return 6.0 / n + f * f / p / n;
    }

    public int supportMinimum() {
        return 0;
    }

    public int supportMaximum() {
        return 0x7FFFFFFE;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (this.size.hashCode() + r);
        r = 37 * ((int)Double.doubleToLongBits(this.succeed) + r);
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof NegativeBinomialDistribution) {
            NegativeBinomialDistribution d = (NegativeBinomialDistribution)o;
            return this.size.equals(d.size) && this.succeed == d.succeed;
        }
        return false;
    }
}

