/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.unix.misc.ParseDate;

public class ShTouch
implements ShProcess {
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        Date d = new Date();
        boolean create = true;
        int k = 1;
        try {
            while (k < args.length) {
                if (args[k].equals("-c")) {
                    create = false;
                    ++k;
                    continue;
                }
                if (args[k].equals("-d") && ++k < args.length) {
                    d = new Date(ParseDate.from(d, args[k++]));
                    continue;
                }
                if (args[k].startsWith("--date=") && args[k].length() > 7) {
                    d = new Date(ParseDate.from(d, args[k++].substring(7)));
                    continue;
                }
                if (args[k].equals("-r") && ++k < args.length) {
                    d = new Date(fs.getFile(args[k++]).getLastModified());
                    continue;
                }
                if (args[k].startsWith("--reference=") && args[k].length() > 12) {
                    d = new Date(fs.getFile(args[k++].substring(12)).getLastModified());
                    continue;
                }
                if (args[k].equals("-t") && ++k < args.length) {
                    d = ParseDate.parseMMDD(args[k++]);
                    continue;
                }
                if (args[k].equals("-f")) {
                    ++k;
                    continue;
                }
                break;
            }
        }
        catch (IllegalArgumentException e) {
            err.println("touch: invalid date");
            return 2;
        }
        int i = k;
        while (i < args.length) {
            ShFile f = fs.getFile(args[k]);
            if (f.isExist()) {
                f.setLastModified(d.getTime());
            } else if (create) {
                PrintStream ous = f.getPrintStream(true);
                ous.close();
            }
            ++i;
        }
        return 0;
    }
}

