/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.a;

import java.util.List;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayEquals
extends AwkFunction {
    protected ArrayEquals() {
        super("equals", null);
    }

    @Override
    public AwkValue apply(AwkNamespace ns, AwkFiles o, List<AwkValue> args) {
        if (args.size() < 2) {
            return AwkInteger.TRUE;
        }
        AwkValue a = args.get(0);
        if (a.isArray()) {
            int i = 1;
            while (i < args.size()) {
                AwkValue b = args.get(i);
                if (!b.isArray() || !a.keys().equals(b.keys())) {
                    return AwkInteger.FALSE;
                }
                for (String s : a.keys()) {
                    AwkValue y;
                    AwkValue x = a.referArray(s);
                    if (x.compareTo(y = b.referArray(s), ns) == 0) continue;
                    return AwkInteger.FALSE;
                }
                ++i;
            }
            return AwkInteger.TRUE;
        }
        return AwkInteger.FALSE;
    }
}

