/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.rel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkFunctionNamespace;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Relations {
    static final String TBLSEP = "TBLSEP";
    static final String SUBSEP = "SUBSEP";
    private static final Pattern P1 = Pattern.compile("^(.*)([0-9]+)#");

    private Relations() {
    }

    public static AwkArray projection(AwkArray table, AwkNamespace namespace, String ... records) {
        AwkArray r = new AwkArray();
        if (records == null) {
            throw new NullPointerException();
        }
        if (records.length == 0) {
            throw new IllegalArgumentException();
        }
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (Map.Entry<String, AwkValue> z : table.entrySet()) {
            String[] rd;
            StringBuffer b = new StringBuffer();
            String d = "";
            String[] stringArray = rd = z.getValue().toString(namespace).split(sep);
            int n = rd.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] stringArray2 = records;
                int n3 = records.length;
                int n4 = 0;
                while (n4 < n3) {
                    String t = stringArray2[n4];
                    if (s.startsWith(String.valueOf(t) + nsp)) {
                        b.append(d).append(s);
                        d = sep;
                    }
                    ++n4;
                }
                ++n2;
            }
            r.putArray(z.getKey(), AwkString.valueOf(b.toString()));
        }
        return r;
    }

    private static String getnm(String s) {
        Matcher m = P1.matcher(s);
        if (m.matches()) {
            return String.valueOf(m.group(1)) + (Integer.parseInt(m.group(2)) + 1);
        }
        return String.valueOf(s) + "1";
    }

    public static AwkArray crossJoin(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        AwkArray r = new AwkArray();
        int c = 1;
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (Map.Entry<String, AwkValue> v : table1.entrySet()) {
            String x = v.getValue().toString(namespace);
            String[] p1 = x.split(sep);
            for (Map.Entry<String, AwkValue> w : table2.entrySet()) {
                String[] q1 = w.getValue().toString(namespace).split(sep);
                StringBuffer b = new StringBuffer(x);
                int i = 0;
                while (i < q1.length) {
                    block5: {
                        String[] t0 = q1[i].split(nsp);
                        int j = 0;
                        while (j < p1.length) {
                            if (p1[j].startsWith(String.valueOf(t0[0]) + nsp)) {
                                b.append(sep);
                                b.append(Relations.getnm(t0[0]));
                                b.append(nsp);
                                b.append(t0[1]);
                                break block5;
                            }
                            ++j;
                        }
                        b.append(sep).append(q1[i]);
                    }
                    ++i;
                }
                r.putArray(String.valueOf(c++), AwkString.valueOf(b.toString()));
            }
        }
        return r;
    }

    private static String _find(String x, String[] p1, String[] q1, String sep, String nsp, AwkNamespace ns) {
        HashMap<String, String> m = new HashMap<String, String>();
        StringBuffer b = new StringBuffer(x);
        int j = 0;
        while (j < p1.length) {
            String[] tp = p1[j].split(nsp);
            m.put(tp[0], tp[1]);
            ++j;
        }
        int i = 0;
        while (i < q1.length) {
            String[] tq = q1[i].split(nsp);
            String y = (String)m.get(tq[0]);
            if (y == null) {
                b.append(sep).append(q1[i]);
            } else if (!y.equals(tq[1])) {
                return null;
            }
            ++i;
        }
        return b.toString();
    }

    public static AwkArray naturalJoin(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        AwkArray r = new AwkArray();
        int c = 1;
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (Map.Entry<String, AwkValue> v : table1.entrySet()) {
            String x = v.getValue().toString(namespace);
            String[] p1 = x.split(sep);
            for (Map.Entry<String, AwkValue> w : table2.entrySet()) {
                String[] q1 = w.getValue().toString(namespace).split(sep);
                String y = Relations._find(x, p1, q1, sep, nsp, namespace);
                if (y == null) continue;
                r.putArray(String.valueOf(c++), AwkString.valueOf(y));
            }
        }
        return r;
    }

    private static Set<String> _find2(String[] p1, String[] q1, String sep, String nsp, AwkNamespace ns, Map<String, Set<String>> uni) {
        HashMap<String, String> m = new HashMap<String, String>();
        boolean r = false;
        int j = 0;
        while (j < p1.length) {
            String[] tp = p1[j].split(nsp);
            m.put(tp[0], tp.length < 2 ? "" : tp[1]);
            ++j;
        }
        HashSet<String> sq = new HashSet<String>();
        int i = 0;
        while (i < q1.length) {
            String[] tq = q1[i].split(nsp);
            sq.add(tq[0]);
            String y = (String)m.get(tq[0]);
            if (y != null) {
                if (!y.equals(tq[1])) {
                    return null;
                }
                Set<String> ss = uni.get(tq[0]);
                if (ss == null || !ss.contains(y)) {
                    if (ss == null) {
                        ss = new HashSet<String>();
                        uni.put(tq[0], ss);
                    }
                    ss.add(y);
                    r = true;
                }
            }
            ++i;
        }
        return r && m.keySet().containsAll(sq) ? sq : null;
    }

    public static AwkArray restriction(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        AwkArray r = new AwkArray();
        int c = 1;
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (Map.Entry<String, AwkValue> v : table1.entrySet()) {
            AwkValue x = v.getValue();
            String[] p1 = x.toString(namespace).split(sep);
            for (Map.Entry<String, AwkValue> w : table2.entrySet()) {
                String[] q1 = w.getValue().toString(namespace).split(sep);
                if (Relations._find2(p1, q1, sep, nsp, namespace, m) == null) continue;
                r.putArray(String.valueOf(c++), x);
            }
        }
        return r;
    }

    public static AwkArray select(AwkArray table, AwkExpression f, AwkNamespace namespace, AwkFiles files) {
        AwkArray r = new AwkArray();
        int c = 1;
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (AwkValue v : table.values()) {
            AwkFunctionNamespace ns = new AwkFunctionNamespace(namespace);
            String[] p1 = v.toString(namespace).split(sep);
            int j = 0;
            while (j < p1.length) {
                String[] tp = p1[j].split(nsp);
                ns.assign(tp[0], AwkValue.cast(tp.length < 2 ? "" : tp[1]));
                ++j;
            }
            if (!f.eval(ns, files).toBoolean(namespace)) continue;
            r.putArray(String.valueOf(c++), v);
        }
        return r;
    }

    private static Set<Map<String, String>> toSetOfMap(AwkArray table, AwkNamespace ns, String sep, String nsp) {
        HashSet<Map<String, String>> t = new HashSet<Map<String, String>>();
        for (AwkValue v : table.values()) {
            String[] p;
            HashMap<String, String> m = new HashMap<String, String>();
            String[] stringArray = p = v.toString(ns).split(sep);
            int n = p.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] q = s.split(nsp);
                m.put(q[0], q.length < 2 ? "" : q[1]);
                ++n2;
            }
            t.add(m);
        }
        return t;
    }

    private static AwkArray toArrayOfString(Set<Map<String, String>> t, String sep, String nsp) {
        AwkArray a = new AwkArray();
        int c = 1;
        for (Map<String, String> m : t) {
            StringBuffer b = new StringBuffer();
            String d = "";
            for (Map.Entry<String, String> z : m.entrySet()) {
                b.append(d).append(z.getKey()).append(nsp);
                b.append(z.getValue());
                d = sep;
            }
            a.putArray(String.valueOf(c++), AwkString.valueOf(b.toString()));
        }
        return a;
    }

    public static AwkArray union(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        Set<Map<String, String>> t1 = Relations.toSetOfMap(table1, namespace, sep, nsp);
        Set<Map<String, String>> t2 = Relations.toSetOfMap(table2, namespace, sep, nsp);
        t1.addAll(t2);
        return Relations.toArrayOfString(t1, sep, nsp);
    }

    public static AwkArray intersect(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        Set<Map<String, String>> t1 = Relations.toSetOfMap(table1, namespace, sep, nsp);
        Set<Map<String, String>> t2 = Relations.toSetOfMap(table2, namespace, sep, nsp);
        t1.retainAll(t2);
        return Relations.toArrayOfString(t1, sep, nsp);
    }

    public static AwkArray except(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        Set<Map<String, String>> t1 = Relations.toSetOfMap(table1, namespace, sep, nsp);
        Set<Map<String, String>> t2 = Relations.toSetOfMap(table2, namespace, sep, nsp);
        t1.removeAll(t2);
        return Relations.toArrayOfString(t1, sep, nsp);
    }

    public static AwkArray divide(AwkArray table1, AwkArray table2, AwkNamespace namespace) {
        HashSet a = null;
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (Map.Entry<String, AwkValue> v : table2.entrySet()) {
            String[] p1 = v.getValue().toString(namespace).split(sep);
            HashSet b = new HashSet();
            for (Map.Entry<String, AwkValue> w : table1.entrySet()) {
                m.clear();
                HashMap<String, String> o = new HashMap<String, String>();
                String[] q1 = w.getValue().toString(namespace).split(sep);
                Set<String> rq = Relations._find2(q1, p1, sep, nsp, namespace, m);
                if (rq == null) continue;
                int i = 0;
                while (i < q1.length) {
                    String[] t1 = q1[i].split(nsp);
                    if (!rq.contains(t1[0])) {
                        o.put(t1[0], t1[1]);
                    }
                    ++i;
                }
                b.add(o);
            }
            if (a == null) {
                a = b;
                continue;
            }
            a.retainAll(b);
        }
        return Relations.toArrayOfString(a, sep, nsp);
    }

    public static AwkValue makeTuple(AwkArray a, AwkNamespace namespace) {
        StringBuffer b = new StringBuffer();
        String d = "";
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        for (Map.Entry<String, AwkValue> z : a.entrySet()) {
            b.append(d).append(z.getKey()).append(nsp);
            b.append(z.getValue().toString(namespace));
            d = sep;
        }
        return AwkString.valueOf(b.toString());
    }

    public static AwkArray makeArray(AwkValue x, AwkNamespace namespace) {
        String[] p;
        AwkArray a = new AwkArray();
        String sep = namespace.getRoot().find(SUBSEP).toString(namespace);
        String nsp = namespace.getRoot().find(TBLSEP).toString(namespace);
        String[] stringArray = p = x.toString(namespace).split(sep);
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] q = s.split(nsp);
            if (q.length < 2) {
                a.putArray(q[0], AwkUndefined.UNDEF);
            } else {
                a.putArray(q[0], AwkValue.cast(q[1]));
            }
            ++n2;
        }
        return a;
    }
}

