/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.awk.matrix.AbstractArrayDoubleMatrix;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.DoubleMatrices;
import net.morilib.awk.matrix.DoubleMatrix;

public class ArrayDoubleMatrix
extends AbstractArrayDoubleMatrix
implements Serializable {
    private double[] array;
    private transient DoubleMatrix[] decomposed = null;

    public ArrayDoubleMatrix(int rows, int columns) {
        this(rows, columns, 0.0);
    }

    public ArrayDoubleMatrix(int rows, int columns, double fill) {
        this.array = new double[rows * columns];
        this.rows = rows;
        this.columns = columns;
        Arrays.fill(this.array, fill);
    }

    public ArrayDoubleMatrix(ArrayDoubleMatrix m) {
        this.array = new double[m.rows * m.columns];
        this.rows = m.rows;
        this.columns = m.columns;
        System.arraycopy(m.array, 0, this.array, 0, this.array.length);
    }

    public ArrayDoubleMatrix(DoubleMatrix m) {
        this.array = new double[m.rowSize() * m.columnSize()];
        this.rows = m.rowSize();
        this.columns = m.columnSize();
        int i = 0;
        while (i < m.rowSize()) {
            int j = 0;
            while (j < m.columnSize()) {
                this.set(i, j, m.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public static ArrayDoubleMatrix newElementMatrix(int size) {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(size, size);
        int i = 0;
        while (i < size) {
            r.set(i, i, 1.0);
            ++i;
        }
        return r;
    }

    protected double array(int index) {
        return this.array[index];
    }

    protected void arrayset(int index, double x) {
        this.array[index] = x;
    }

    protected ArrayDoubleMatrix prototype() {
        return new ArrayDoubleMatrix(this.rows, this.columns);
    }

    protected ArrayDoubleMatrix prototype(int rows, int columns) {
        return new ArrayDoubleMatrix(rows, columns);
    }

    public ArrayDoubleMatrix clone() {
        return new ArrayDoubleMatrix(this);
    }

    protected void arraycopy(int srcPos, Object dest, int destPos, int len) {
        System.arraycopy(this.array, srcPos, dest, destPos, len);
    }

    public double determinant() throws AwkMatrixException {
        if (this.columns != this.rows) {
            throw new AwkMatrixException("square matrix required");
        }
        if (this.decomposed == null) {
            this.decomposed = DoubleMatrices.decomposeLU(this);
        }
        return this.decomposed[0].determinant() * this.decomposed[2].determinant();
    }

    public DoubleMatrix inv() throws AwkMatrixException {
        if (this.columns != this.rows) {
            throw new AwkMatrixException("square matrix required");
        }
        if (this.decomposed == null) {
            this.decomposed = DoubleMatrices.decomposeLU(this);
        }
        DoubleMatrix x = this.decomposed[2].inv();
        DoubleMatrix y = this.decomposed[1].inv();
        x = x.mul(y);
        y = this.decomposed[0].inv();
        x = x.mul(y);
        return x;
    }
}

