/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.AbstractImmutableDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleMatrix;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.DoubleMatrix;

public class LUDecomposedUMatrix
extends AbstractImmutableDoubleMatrix {
    private DoubleMatrix a;

    LUDecomposedUMatrix(DoubleMatrix a) {
        this.a = a;
    }

    public double get(int row, int column) {
        return row > column ? 0.0 : this.a.get(row, column);
    }

    public int rowSize() {
        return this.a.rowSize();
    }

    public int columnSize() {
        return this.a.columnSize();
    }

    public double determinant() {
        double r = 1.0;
        int i = 0;
        while (i < this.a.rowSize()) {
            r *= this.a.get(i, i);
            ++i;
        }
        return r;
    }

    public DoubleMatrix inv() throws AwkMatrixException {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        if (this.determinant() == 0.0) {
            throw new AwkMatrixException("this matrix is not regular");
        }
        int i = 0;
        while (i < this.columnSize()) {
            r.set(i, i, 1.0 / r.get(i, i));
            ++i;
        }
        int c = 1;
        while (c < this.rowSize()) {
            int i2 = c;
            while (i2 < this.columnSize()) {
                int j = i2 - c;
                double x = 0.0;
                int k = j + 1;
                while (k <= i2) {
                    double c1 = this.get(j, k);
                    double c2 = r.get(k, i2);
                    x += c1 * c2;
                    ++k;
                }
                r.set(j, i2, -(x * r.get(j, j)));
                ++i2;
            }
            ++c;
        }
        return r;
    }
}

