/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.AwkLexerException;
import net.morilib.awk.AwkSyntaxException;
import net.morilib.awk.misc.PromptReader;
import net.morilib.awk.misc.PushbackLineNumberReadable;
import net.morilib.awk.misc.PushbackLineNumberReader;
import net.morilib.awk.parser.AwkAssignop;
import net.morilib.awk.parser.AwkFloatToken;
import net.morilib.awk.parser.AwkIntegerToken;
import net.morilib.awk.parser.AwkOperator;
import net.morilib.awk.parser.AwkRelop;
import net.morilib.awk.parser.AwkReserved;
import net.morilib.awk.parser.AwkStringToken;
import net.morilib.awk.parser.AwkSymbol;
import net.morilib.awk.parser.AwkToken;

public final class AwkLexer {
    private static final Map<Integer, AwkToken> OP1;
    private static final Map<String, AwkToken> RES1;
    private AwkToken token;
    private PushbackLineNumberReadable reader;
    private int headchr = 0;
    private boolean reset = false;
    private int blocks = 0;

    static {
        HashMap<Integer, AwkToken> o = new HashMap<Integer, AwkToken>();
        HashMap<String, AwkToken> r = new HashMap<String, AwkToken>();
        o.put(63, AwkOperator.TRI1);
        o.put(58, AwkOperator.TRI2);
        o.put(126, AwkOperator.MATCH);
        o.put(40, AwkOperator.LPAREN);
        o.put(41, AwkOperator.RPAREN);
        o.put(123, AwkReserved.BLOCK_B);
        o.put(125, AwkReserved.BLOCK_E);
        o.put(44, AwkOperator.COMMA);
        o.put(36, AwkOperator.FIELD);
        o.put(59, AwkReserved.SEMICL);
        o.put(10, AwkReserved.EOL);
        o.put(91, AwkOperator.LBRAKET);
        o.put(93, AwkOperator.RBRAKET);
        o.put(64, AwkOperator.REFFN);
        OP1 = Collections.unmodifiableMap(o);
        r.put("if", AwkReserved.IF);
        r.put("else", AwkReserved.ELSE);
        r.put("for", AwkReserved.FOR);
        r.put("in", AwkOperator.IN);
        r.put("while", AwkReserved.WHILE);
        r.put("do", AwkReserved.DO);
        r.put("break", AwkReserved.BREAK);
        r.put("continue", AwkReserved.CONT);
        r.put("next", AwkReserved.NEXT);
        r.put("exit", AwkReserved.EXIT);
        r.put("delete", AwkReserved.DELETE);
        r.put("function", AwkReserved.FUNC);
        r.put("print", AwkReserved.PRINT);
        r.put("printf", AwkReserved.PRINTF);
        r.put("getline", AwkReserved.GETLINE);
        r.put("close", AwkReserved.CLOSE);
        RES1 = Collections.unmodifiableMap(r);
    }

    public AwkLexer(Reader rd) throws IOException {
        this.reader = new PushbackLineNumberReader(rd);
        this.headchr = this.reader.read();
        if (this.headchr >= 0) {
            this.reader.unread(this.headchr);
        }
        this.token = AwkLexer.getToken(this.reader);
    }

    public AwkLexer(String prompt1, String prompt2, Reader rd) throws IOException {
        this.reader = new PromptReader(prompt1, prompt2, rd);
        this.headchr = this.reader.read();
        if (this.headchr >= 0) {
            this.reader.unread(this.headchr);
        }
        this.token = AwkLexer.getToken(this.reader);
    }

    public AwkToken getToken() throws IOException {
        if (this.reset) {
            this.reset = false;
            this.headchr = this.reader.read();
            if (this.headchr >= 0) {
                this.reader.unread(this.headchr);
            }
            this.token = AwkLexer.getToken(this.reader);
        }
        return this.token;
    }

    public AwkToken nextToken() throws IOException {
        if (!this.token.equals(AwkReserved.ENDMARKER)) {
            if (this.blocks == 0 && this.reader.isNewline()) {
                this.token = AwkReserved.ENDMARKER;
            } else {
                this.headchr = this.reader.read();
                if (this.headchr >= 0) {
                    this.reader.unread(this.headchr);
                }
                this.token = AwkLexer.getToken(this.reader);
            }
        }
        return this.token;
    }

    public AwkToken nextTokenBegin() throws IOException {
        ++this.blocks;
        if (!this.token.equals(AwkReserved.ENDMARKER)) {
            this.headchr = this.reader.read();
            if (this.headchr >= 0) {
                this.reader.unread(this.headchr);
            }
            this.token = AwkLexer.getToken(this.reader);
        }
        return this.token;
    }

    public boolean isEos() throws IOException {
        return this.token.equals(AwkReserved.SEMICL) || this.token.equals(AwkReserved.BLOCK_B) || this.token.equals(AwkReserved.BLOCK_E) || this.token.equals(AwkOperator.IN) || this.token.equals(AwkReserved.APNDOUT) || this.token.equals(AwkReserved.PIPE) || this.token.equals(AwkReserved.ENDMARKER) || this.headchr == 10;
    }

    public boolean eatEos() throws IOException {
        if (this.token.equals(AwkReserved.SEMICL)) {
            this.nextToken();
            return true;
        }
        if (this.token.equals(AwkReserved.ENDMARKER)) {
            return true;
        }
        return this.token.equals(AwkReserved.BLOCK_E) || this.token.equals(AwkReserved.ENDMARKER) || this.headchr == 10;
    }

    public AwkToken eatToken(AwkToken t) throws IOException {
        if (!this.token.equals(t)) {
            throw new AwkSyntaxException(this.getLineNumber(), t, this.token);
        }
        return this.nextToken();
    }

    public AwkToken eatTokenEnd(AwkToken t) throws IOException {
        --this.blocks;
        if (!this.token.equals(t)) {
            throw new AwkSyntaxException(this.getLineNumber(), t, this.token);
        }
        if (this.reader instanceof PromptReader && this.reader.isNewline() && this.blocks == 0) {
            return AwkReserved.ENDMARKER;
        }
        return this.nextToken();
    }

    public AwkToken eatTokenOpt(AwkToken t) throws IOException {
        if (this.token.equals(t)) {
            return this.nextToken();
        }
        return this.token;
    }

    public String getPattern() throws IOException {
        return AwkLexer.getPattern(this.reader);
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public void resetPrompt() throws IOException {
        this.reader.resetPrompt();
        this.reset = true;
    }

    public boolean isNewline() throws IOException {
        return this.reader.isNewline();
    }

    private static int rde(PushbackLineNumberReadable rd) throws IOException {
        int c = rd.read();
        if (c < 0) {
            throw new AwkLexerException(-1, "unexpected EOF");
        }
        return c;
    }

    private static int skipws(PushbackLineNumberReadable rd) throws IOException {
        int c;
        boolean cm = false;
        while ((c = rd.read()) >= 0) {
            if (cm) {
                cm = c != 10;
                continue;
            }
            if (c == 35) {
                cm = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        if (c < 0) {
            throw new EndException();
        }
        return c;
    }

    private static AwkToken getr(String s) {
        return RES1.containsKey(s) ? RES1.get(s) : AwkSymbol.getInstance(s);
    }

    private static boolean isnum(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isAwkIdentifierStart(int c) {
        return Character.isLetter(c) || Character.isDigit(c) && !AwkLexer.isnum(c) || Character.getType(c) == 10 || c == 95;
    }

    private static boolean isAwkIdentifierPart(int c) {
        return Character.isLetter(c) || Character.isDigit(c) || Character.getType(c) == 10 || c == 95;
    }

    private static int getoct1(PushbackLineNumberReadable rd) throws IOException {
        int c = AwkLexer.rde(rd);
        if (c < 48 || c > 55) {
            throw new AwkLexerException(rd.getLineNumber(), "octal number required");
        }
        return c - 48;
    }

    private static int getoct(PushbackLineNumberReadable rd) throws IOException {
        return AwkLexer.getoct1(rd) * 64 + AwkLexer.getoct1(rd) * 8 + AwkLexer.getoct1(rd);
    }

    private static int gethex1(PushbackLineNumberReadable rd) throws IOException {
        int c = AwkLexer.rde(rd);
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        throw new AwkLexerException(rd.getLineNumber(), "hexadecimal number required");
    }

    private static int gethex(PushbackLineNumberReadable rd) throws IOException {
        return AwkLexer.gethex1(rd) * 4096 + AwkLexer.gethex1(rd) * 256 + AwkLexer.gethex1(rd) * 16 + AwkLexer.gethex1(rd);
    }

    private static int gethex2(PushbackLineNumberReadable rd) throws IOException {
        return AwkLexer.gethex1(rd) * 16 + AwkLexer.gethex1(rd);
    }

    static AwkToken _getToken(PushbackLineNumberReadable rd) throws IOException {
        StringBuffer b1 = new StringBuffer();
        St1 stat = St1.INIT;
        block29: while (true) {
            switch (stat) {
                case INIT: {
                    int c = AwkLexer.skipws(rd);
                    if (c == 60) {
                        stat = St1.LT;
                        continue block29;
                    }
                    if (c == 62) {
                        stat = St1.GT;
                        continue block29;
                    }
                    if (c == 61) {
                        stat = St1.EQ;
                        continue block29;
                    }
                    if (c == 33) {
                        stat = St1.EX;
                        continue block29;
                    }
                    if (c == 38) {
                        stat = St1.AND;
                        continue block29;
                    }
                    if (c == 124) {
                        stat = St1.OR;
                        continue block29;
                    }
                    if (c == 34) {
                        stat = St1.STRING;
                        continue block29;
                    }
                    if (c == 43) {
                        stat = St1.PLUS;
                        continue block29;
                    }
                    if (c == 45) {
                        stat = St1.MINUS;
                        continue block29;
                    }
                    if (c == 42) {
                        stat = St1.ASTERISK;
                        continue block29;
                    }
                    if (c == 47) {
                        stat = St1.SLASH;
                        continue block29;
                    }
                    if (c == 37) {
                        stat = St1.PERCENT;
                        continue block29;
                    }
                    if (c == 94) {
                        stat = St1.CARET;
                        continue block29;
                    }
                    if (c == 92) continue block29;
                    if (OP1.containsKey(c)) {
                        return OP1.get(c);
                    }
                    if (c == 48) {
                        stat = St1.ZERO;
                        continue block29;
                    }
                    if (c >= 49 && c <= 57) {
                        b1 = new StringBuffer().append((char)c);
                        stat = St1.NUMBER;
                        continue block29;
                    }
                    if (c == 46) {
                        b1 = new StringBuffer().append((char)c);
                        stat = St1.DOT;
                        continue block29;
                    }
                    if (!AwkLexer.isAwkIdentifierStart(c)) continue block29;
                    b1 = new StringBuffer().appendCodePoint(c);
                    stat = St1.KEYWORD;
                    continue block29;
                }
                case LT: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkRelop.LT;
                    }
                    if (c == 61) {
                        return AwkRelop.LE;
                    }
                    rd.unread(c);
                    return AwkRelop.LT;
                }
                case GT: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkRelop.GT;
                    }
                    if (c == 61) {
                        return AwkRelop.GE;
                    }
                    if (c == 62) {
                        return AwkReserved.APNDOUT;
                    }
                    rd.unread(c);
                    return AwkRelop.GT;
                }
                case EQ: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkAssignop.ASSIGN;
                    }
                    if (c == 61) {
                        return AwkRelop.EQ;
                    }
                    rd.unread(c);
                    return AwkAssignop.ASSIGN;
                }
                case EX: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.L_NOT;
                    }
                    if (c == 61) {
                        return AwkRelop.NE;
                    }
                    if (c == 126) {
                        return AwkOperator.NMATCH;
                    }
                    rd.unread(c);
                    return AwkOperator.L_NOT;
                }
                case AND: {
                    int c = rd.read();
                    if (c < 0) {
                        throw new AwkLexerException(rd.getLineNumber(), "'&' is not a valid token");
                    }
                    if (c == 38) {
                        return AwkOperator.L_AND;
                    }
                    throw new AwkLexerException(rd.getLineNumber(), "'&' is not a valid token");
                }
                case OR: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkReserved.PIPE;
                    }
                    if (c == 124) {
                        return AwkOperator.L_OR;
                    }
                    rd.unread(c);
                    return AwkReserved.PIPE;
                }
                case PLUS: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.ADD;
                    }
                    if (c == 43) {
                        return AwkOperator.INC;
                    }
                    if (c == 61) {
                        return AwkAssignop.A_ADD;
                    }
                    rd.unread(c);
                    return AwkOperator.ADD;
                }
                case MINUS: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.SUB;
                    }
                    if (c == 45) {
                        return AwkOperator.DEC;
                    }
                    if (c == 61) {
                        return AwkAssignop.A_SUB;
                    }
                    rd.unread(c);
                    return AwkOperator.SUB;
                }
                case ASTERISK: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.MUL;
                    }
                    if (c == 61) {
                        return AwkAssignop.A_MUL;
                    }
                    rd.unread(c);
                    return AwkOperator.MUL;
                }
                case SLASH: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.DIV;
                    }
                    if (c == 61) {
                        return AwkAssignop.A_DIV;
                    }
                    rd.unread(c);
                    return AwkOperator.DIV;
                }
                case PERCENT: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.MOD;
                    }
                    if (c == 61) {
                        return AwkAssignop.A_MOD;
                    }
                    rd.unread(c);
                    return AwkOperator.MOD;
                }
                case CARET: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.POW;
                    }
                    if (c == 61) {
                        return AwkAssignop.A_POW;
                    }
                    rd.unread(c);
                    return AwkOperator.POW;
                }
                case DOT: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkOperator.NAME;
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT2;
                    } else {
                        rd.unread(c);
                        return AwkOperator.NAME;
                    }
                }
                case KEYWORD: {
                    int c = rd.read();
                    if (c < 0) {
                        return AwkLexer.getr(b1.toString());
                    }
                    if (!AwkLexer.isAwkIdentifierPart(c)) {
                        rd.unread(c);
                        return AwkLexer.getr(b1.toString());
                    }
                    b1.appendCodePoint(c);
                    continue block29;
                }
                case STRING: {
                    int c = AwkLexer.rde(rd);
                    if (c == 92) {
                        stat = St1.STRING_ESC;
                        continue block29;
                    }
                    if (c == 34) {
                        return AwkStringToken.getInstance(b1.toString());
                    }
                    b1.appendCodePoint(c);
                    continue block29;
                }
                case STRING_ESC: {
                    int c = AwkLexer.rde(rd);
                    if (c == 34) {
                        b1.append('\"');
                    } else if (c == 110) {
                        b1.append('\n');
                    } else if (c == 114) {
                        b1.append('\r');
                    } else if (c == 97) {
                        b1.append('\u0007');
                    } else if (c == 98) {
                        b1.append('\b');
                    } else if (c == 102) {
                        b1.append('\f');
                    } else if (c == 116) {
                        b1.append('\t');
                    } else if (c == 118) {
                        b1.append('\u000b');
                    } else if (AwkLexer.isnum(c)) {
                        rd.unread(c);
                        b1.append((char)AwkLexer.getoct(rd));
                    } else if (c == 117) {
                        b1.append((char)AwkLexer.gethex(rd));
                    } else if (c == 120) {
                        b1.append((char)AwkLexer.gethex2(rd));
                    } else {
                        b1.appendCodePoint(c);
                    }
                    stat = St1.STRING;
                    continue block29;
                }
                case ZERO: {
                    int c = rd.read();
                    if (c < 0) {
                        return new AwkIntegerToken("0", 10);
                    }
                    if (c == 120) {
                        stat = St1.NUMBER_HEX;
                        continue block29;
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.NUMBER_OCT;
                        continue block29;
                    }
                    if (c == 46) {
                        b1.append('0').append((char)c);
                        stat = St1.FLOAT1;
                        continue block29;
                    }
                    rd.unread(c);
                    return new AwkIntegerToken("0", 10);
                }
                case NUMBER: {
                    int c = rd.read();
                    if (c < 0) {
                        return new AwkIntegerToken(b1.toString(), 10);
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block29;
                    }
                    if (c == 46) {
                        b1.append((char)c);
                        stat = St1.FLOAT1;
                        continue block29;
                    }
                    if (c == 101 || c == 69) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E1;
                        continue block29;
                    }
                    rd.unread(c);
                    return new AwkIntegerToken(b1.toString(), 10);
                }
                case NUMBER_OCT: {
                    int c = rd.read();
                    if (c < 0) {
                        return new AwkIntegerToken(b1.toString(), 8);
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block29;
                    }
                    rd.unread(c);
                    return new AwkIntegerToken(b1.toString(), 8);
                }
                case NUMBER_HEX: {
                    int c = rd.read();
                    if (c < 0) {
                        return new AwkIntegerToken(b1.toString(), 16);
                    }
                    if (c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
                        b1.append((char)c);
                        continue block29;
                    }
                    rd.unread(c);
                    return new AwkIntegerToken(b1.toString(), 16);
                }
                case FLOAT1: {
                    int c = AwkLexer.rde(rd);
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT2;
                        continue block29;
                    }
                    throw new AwkLexerException(rd.getLineNumber(), "invalid float number");
                }
                case FLOAT2: {
                    int c = rd.read();
                    if (c < 0) {
                        return new AwkFloatToken(b1.toString());
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block29;
                    }
                    if (c == 101 || c == 69) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E1;
                        continue block29;
                    }
                    rd.unread(c);
                    return new AwkFloatToken(b1.toString());
                }
                case FLOAT_E1: {
                    int c = AwkLexer.rde(rd);
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E3;
                        continue block29;
                    }
                    if (c == 43 || c == 45) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E2;
                        continue block29;
                    }
                    throw new AwkLexerException(rd.getLineNumber(), "invalid float number");
                }
                case FLOAT_E2: {
                    int c = AwkLexer.rde(rd);
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        stat = St1.FLOAT_E3;
                        continue block29;
                    }
                    throw new AwkLexerException(rd.getLineNumber(), "invalid float number");
                }
                case FLOAT_E3: {
                    int c = rd.read();
                    if (c < 0) {
                        return new AwkFloatToken(b1.toString());
                    }
                    if (c >= 48 && c <= 57) {
                        b1.append((char)c);
                        continue block29;
                    }
                    rd.unread(c);
                    return new AwkFloatToken(b1.toString());
                }
                case BACKSLASH: {
                    int c = rd.read();
                    if (c == 10) {
                        stat = St1.INIT;
                        continue block29;
                    }
                    if (c == 13) continue block29;
                    throw new AwkLexerException(rd.getLineNumber(), "invalid token");
                }
            }
        }
    }

    public static AwkToken getToken(PushbackLineNumberReadable rd) throws IOException {
        try {
            return AwkLexer._getToken(rd);
        }
        catch (EndException e) {
            return AwkReserved.ENDMARKER;
        }
    }

    public static String getPattern(PushbackLineNumberReadable rd) throws IOException {
        StringBuffer b = new StringBuffer();
        boolean esc = false;
        while (true) {
            int c;
            if ((c = rd.read()) < 0) {
                throw new AwkLexerException(rd.getLineNumber(), "unexpected EOF");
            }
            if (esc) {
                esc = false;
            } else {
                if (c == 47) {
                    return b.toString();
                }
                esc = c == 92;
            }
            b.appendCodePoint(c);
        }
    }

    private static int getoct(String s, int i) {
        block3: {
            try {
                if (i + 2 < s.length()) break block3;
                return -1;
            }
            catch (NumberFormatException e) {
                return 63;
            }
        }
        return Integer.parseInt(s.substring(i, i + 3), 8);
    }

    private static int gethex(String s, int i) {
        block3: {
            try {
                if (i + 3 < s.length()) break block3;
                return -1;
            }
            catch (NumberFormatException e) {
                return 63;
            }
        }
        return Integer.parseInt(s.substring(i, i + 4), 16);
    }

    private static int gethex2(String s, int i) {
        block3: {
            try {
                if (i + 1 < s.length()) break block3;
                return -1;
            }
            catch (NumberFormatException e) {
                return 63;
            }
        }
        return Integer.parseInt(s.substring(i, i + 2), 16);
    }

    public static String escape(String s) {
        StringBuffer b1 = new StringBuffer();
        St2 stat = St2.STRING;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (stat) {
                case STRING: {
                    if (c == '\\') {
                        stat = St2.STRING_ESC;
                        break;
                    }
                    b1.appendCodePoint(c);
                    break;
                }
                case STRING_ESC: {
                    int d;
                    if (c == '\"') {
                        b1.append('\"');
                    } else if (c == 'n') {
                        b1.append('\n');
                    } else if (c == 'r') {
                        b1.append('\r');
                    } else if (c == 'a') {
                        b1.append('\u0007');
                    } else if (c == 'b') {
                        b1.append('\b');
                    } else if (c == 'f') {
                        b1.append('\f');
                    } else if (c == 't') {
                        b1.append('\t');
                    } else if (c == 'v') {
                        b1.append('\u000b');
                    } else if (AwkLexer.isnum(c)) {
                        d = AwkLexer.getoct(s, i);
                        if (d < 0) {
                            b1.append('\\');
                            b1.append(s.substring(i));
                            return b1.toString();
                        }
                        b1.append((char)d);
                        i += 2;
                    } else if (c == 'u') {
                        d = AwkLexer.gethex(s, i + 1);
                        if (d < 0) {
                            b1.append('\\');
                            b1.append(s.substring(i));
                            return b1.toString();
                        }
                        b1.append((char)d);
                        i += 4;
                    } else if (c == 'x') {
                        d = AwkLexer.gethex2(s, i + 1);
                        if (d < 0) {
                            b1.append('\\');
                            b1.append(s.substring(i));
                            return b1.toString();
                        }
                        b1.append((char)d);
                        i += 2;
                    } else {
                        b1.appendCodePoint(c);
                    }
                    stat = St2.STRING;
                }
            }
            ++i;
        }
        if (stat.equals((Object)St2.STRING_ESC)) {
            b1.append('\\');
        }
        return b1.toString();
    }

    private static class EndException
    extends RuntimeException {
        private EndException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum St1 {
        INIT,
        LT,
        GT,
        EQ,
        EX,
        AND,
        OR,
        KEYWORD,
        STRING,
        STRING_ESC,
        PLUS,
        MINUS,
        ASTERISK,
        SLASH,
        CARET,
        PERCENT,
        DOT,
        BACKSLASH,
        ZERO,
        NUMBER,
        NUMBER_OCT,
        NUMBER_HEX,
        FLOAT1,
        FLOAT2,
        FLOAT_E1,
        FLOAT_E2,
        FLOAT_E3;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum St2 {
        STRING,
        STRING_ESC;

    }
}

