/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.morilib.diff.EditScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Change<T> {
    public static final int CHANGED = 1;
    public static final int INSERTED = 2;
    public static final int DELETED = 3;
    int beginA;
    int endA;
    int beginB;
    int endB;
    int operation;
    List<T> before = new ArrayList<T>();
    List<T> after = new ArrayList<T>();

    Change() {
    }

    public int getBeginIndexA() {
        return this.beginA;
    }

    public int getEndIndexA() {
        return this.endA;
    }

    public int getBeginIndexB() {
        return this.beginB;
    }

    public int getEndIndexB() {
        return this.endB;
    }

    public int getOperation() {
        return this.operation;
    }

    public List<T> getBefore() {
        return this.before;
    }

    public List<T> getAfter() {
        return this.after;
    }

    private Change<T> confirm(int op) {
        this.operation = op;
        this.before = Collections.unmodifiableList(this.before);
        this.after = Collections.unmodifiableList(this.after);
        return this;
    }

    private static <E> E next(Iterator<E> itr) {
        return itr.hasNext() ? (E)itr.next() : null;
    }

    static <T> List<Change<T>> makechange(List<EditScript<T>> scripts) {
        Iterator<EditScript<T>> itr = scripts.iterator();
        ArrayList<Change<T>> r = new ArrayList<Change<T>>();
        int stat = 100;
        int al = 1;
        int bl = 1;
        Change<T> ch = null;
        EditScript<T> e = itr.next();
        while (true) {
            switch (stat) {
                case 100: {
                    if (e == null) {
                        return r;
                    }
                    ch = new Change<T>();
                    bl += e.getIndex() - al;
                    ch.beginA = ch.endA = (al = e.getIndex());
                    if (e.isDelete()) {
                        ch.beginB = ch.endB = bl;
                        ch.before.add(e.getObject());
                        stat = 101;
                    } else {
                        ch.beginB = ch.endB = ++bl;
                        ch.after.add(e.getObject());
                        stat = 102;
                    }
                    e = Change.next(itr);
                    break;
                }
                case 101: {
                    if (e == null) {
                        ch.endB = ch.beginB = bl - 1;
                        ch.endA = al;
                        r.add(super.confirm(3));
                        stat = 100;
                        break;
                    }
                    if (e.isDelete()) {
                        if (++al != e.getIndex()) {
                            ch.endB = ch.beginB = bl - 1;
                            ch.endA = al - 1;
                            r.add(super.confirm(3));
                            stat = 100;
                            break;
                        }
                        ch.before.add(e.getObject());
                        e = Change.next(itr);
                        break;
                    }
                    if (al != e.getIndex()) {
                        ch.endA = al;
                        r.add(super.confirm(3));
                        stat = 100;
                        break;
                    }
                    ++bl;
                    ch.after.add(e.getObject());
                    ch.endA = al;
                    stat = 103;
                    e = Change.next(itr);
                    break;
                }
                case 102: {
                    if (e == null || e.isDelete() || al != e.getIndex()) {
                        ch.endB = bl;
                        r.add(super.confirm(2));
                        stat = 100;
                        break;
                    }
                    ++bl;
                    ch.after.add(e.getObject());
                    e = Change.next(itr);
                    break;
                }
                case 103: {
                    if (e == null || e.isDelete() || al != e.getIndex()) {
                        ch.endB = --bl;
                        r.add(super.confirm(1));
                        stat = 100;
                        break;
                    }
                    ++bl;
                    ch.after.add(e.getObject());
                    e = Change.next(itr);
                }
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        switch (this.operation) {
            case 3: {
                return String.valueOf(this.beginA) + "," + this.endA + "d";
            }
            case 2: {
                return String.valueOf(this.beginA) + "a";
            }
            case 1: {
                return String.valueOf(this.beginA) + "," + this.endA + "c" + this.beginB + "," + this.endB;
            }
        }
        return b.toString();
    }
}

