/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.file.AbstractShEnvironment;
import net.morilib.sh.file.ShWindowsFileSystem;

public class ShWindowsEnvironment
extends AbstractShEnvironment {
    private Map<String, String> map;
    private Map<String, ShEnvironment.Attributes> attrs = new HashMap<String, ShEnvironment.Attributes>();

    ShWindowsEnvironment() {
        try {
            this.map = new HashMap<String, String>(System.getenv());
            this.setpath();
            if (this.map.containsKey("HOMEDRIVE") && this.map.containsKey("HOMEPATH")) {
                this.map.put("HOME", ShWindowsFileSystem.toJshFilename(String.valueOf(this.map.get("HOMEDRIVE")) + this.map.get("HOMEPATH")));
            }
        }
        catch (SecurityException e) {
            this.map = new HashMap<String, String>();
        }
    }

    public void bind(String name, String value) {
        this.map.put(name, value);
        this.setpath();
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public String find(String name) {
        return this.map.containsKey(name) ? this.map.get(name) : "";
    }

    public ShEnvironment getEnvironment() {
        return null;
    }

    public void put(String name, String value) {
        this.map.put(name, value);
    }

    public Properties toProperties() {
        Properties r = new Properties();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            r.setProperty(e.getKey(), e.getValue());
        }
        return r;
    }

    public void export(String name) {
        this.map.put(name, "");
    }

    public void unbind(String name) {
        this.map.remove(name);
    }

    public boolean isReadonly(String name) {
        ShEnvironment.Attributes a = this.attrs.get(name);
        return a != null && a.isReadonly();
    }

    public void setReadonly(String name) {
        if (this.map.containsKey(name)) {
            this.attrs.put(name, READONLY);
        }
    }
}

