/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.ShStat;
import net.morilib.sh.file.ShWindowsRealFile;

public class ShWindowsFileSystem
implements ShFileSystem {
    private static final String SEP = System.getProperty("file.separator");
    private static final Pattern WPN = Pattern.compile("([A-Za-z]):[/\\\\]+(.*)");
    private final ShFile root = new ShFile(){

        @Override
        public Collection<ShFile> getFiles() {
            ArrayList<ShFile> l = new ArrayList<ShFile>();
            TreeSet<String> z = new TreeSet<String>();
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File g = fileArray[n2];
                z.add(g.toString().substring(0, 1));
                ++n2;
            }
            for (String s : z) {
                ShWindowsRealFile f = new ShWindowsRealFile(ShWindowsFileSystem.this, s.toLowerCase(), new File(String.valueOf(s) + ":"));
                l.add(f);
            }
            return l;
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public PrintStream getPrintStream(boolean append) {
            return null;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isExecutable() {
            return true;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public long getLastModified() {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return false;
        }

        @Override
        public ShProcess getProcess(String ... args) {
            return null;
        }

        @Override
        public ShFile toAbsolute() {
            return this;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean renameTo(ShFile f) {
            return false;
        }

        public String toString() {
            return "/";
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public boolean rmdir() {
            return false;
        }

        @Override
        public boolean deleteFile() {
            return false;
        }

        @Override
        public ShStat getStat() {
            return new ShStat("/", 0L, 0L, 15);
        }
    };
    private String home;
    private ShFile realcur;
    private ShSecurityPolicy security;

    public ShWindowsFileSystem(String home, ShSecurityPolicy security) {
        this.home = home;
        this.security = security;
    }

    public static String toJshFilename(String wpath) {
        String[] a;
        StringBuffer b = new StringBuffer("/");
        Matcher m = WPN.matcher(wpath);
        if (!m.matches()) {
            return "";
        }
        b.append(m.group(1).toLowerCase()).append('/');
        String[] stringArray = a = m.group(2).split("[/\\\\]+");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            b.append('/').append(s);
            ++n2;
        }
        return b.toString();
    }

    public ShFile getCurrentDirectory() {
        return this.realcur;
    }

    public void setCurrentDirectory(ShFile s) {
        this.realcur = s;
    }

    public ShFile getFile(String s) {
        StringBuffer b = new StringBuffer();
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.length() == 0) {
            return this.getCurrentDirectory();
        }
        if (s.matches("/+")) {
            return this.root;
        }
        if (s.charAt(0) == '/') {
            String v;
            String t = s.replaceFirst("^/+", "");
            t = t.replaceFirst("/+$", "");
            t = t.replaceAll("^(/\\.\\.)+", "/");
            do {
                v = t;
            } while (!(t = t.replaceAll("/[^/]+/\\.\\.", "")).equals(v));
            t = t.replaceAll("(/\\.)+/", "/");
            t = t.replaceAll("(/\\.)+$", "");
            String[] a = t.split("/+");
            v = s.replaceAll("/+", "/");
            if (a[0].length() != 1 || a[0].charAt(0) < 'a' || a[0].charAt(0) > 'z') {
                return null;
            }
            b.append('/').append(a[0].toUpperCase()).append(':');
            int i = 1;
            while (i < a.length) {
                b.append(SEP).append(a[i]);
                ++i;
            }
            return new ShWindowsRealFile(this, v, new File(b.toString()));
        }
        return this.getFile(this.getCurrentDirectory(), s);
    }

    public ShFile getFile(String dir, String name) {
        return this.getFile(String.valueOf(dir) + "/" + name);
    }

    public ShFile getFile(ShFile dir, String name) {
        return this.getFile(dir + "/" + name);
    }

    public ShFile getRoot() {
        return this.root;
    }

    public ShSecurityPolicy getSecurityPolicy() {
        return this.security;
    }

    public InputStream getProfile() {
        try {
            ShFile f = this.getFile(this.home, "jsh_profile.sh");
            if (f.isFile() || (f = this.getFile(this.home, "jsh_login.sh")).isFile() || (f = this.getFile(this.home, "profile.sh")).isFile()) {
                return f.getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getRc() {
        try {
            ShFile f = this.getFile(this.home, "jshrc.sh");
            if (f.isFile()) {
                return f.getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public ShFile getHome() {
        return this.getFile(this.home);
    }
}

