/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.charset;

import net.morilib.unix.charset.IntInterval;
import net.morilib.unix.charset.IntRange;
import net.morilib.unix.charset.UnixCharSetException;

public final class UnixCharSets {
    public static final IntInterval ALL_CHAR = new IntInterval(0, 65535);

    private UnixCharSets() {
    }

    private static IntInterval getintv(int ch, int ch2) {
        return new IntInterval(ch, ch2);
    }

    static boolean parse(CharSequence s, CharSetHandler h) {
        StringBuilder b = new StringBuilder();
        int st = 1;
        int cb = -1;
        int pt = 0;
        block19: while (pt < s.length()) {
            int cz;
            block35: {
                int c = s.charAt(pt++);
                if (st == 1) {
                    if (c == 92) {
                        st = 2;
                        continue;
                    }
                    cb = c;
                    st = 4;
                    continue;
                }
                if (st == 2) {
                    switch (c) {
                        case 117: 
                        case 120: {
                            st = 3;
                            continue block19;
                        }
                        case 92: {
                            cb = c;
                            st = 4;
                            continue block19;
                        }
                        case 116: {
                            cb = 9;
                            st = 4;
                            continue block19;
                        }
                        case 110: {
                            cb = 10;
                            st = 4;
                            continue block19;
                        }
                        case 114: {
                            cb = 13;
                            st = 4;
                            continue block19;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (st == 3) {
                    if (pt + 2 >= s.length()) {
                        return false;
                    }
                    b.append((char)c);
                    b.append(s.charAt(pt++));
                    b.append(s.charAt(pt++));
                    b.append(s.charAt(pt++));
                    try {
                        cb = Integer.parseInt(b.toString(), 16);
                        b.delete(0, b.length());
                        st = 4;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Illegal code");
                    }
                }
                if (st == 4) {
                    if (c == 92) {
                        h.singleChar(cb);
                        st = 2;
                        continue;
                    }
                    if (c == 45) {
                        st = 5;
                        continue;
                    }
                    h.singleChar(cb);
                    cb = c;
                    st = 4;
                    continue;
                }
                if (st == 5) {
                    if (c == 92) {
                        st = 6;
                        continue;
                    }
                    if (c < cb) {
                        return false;
                    }
                    h.rangedChar(cb, c);
                    st = 1;
                    continue;
                }
                if (st == 6) {
                    switch (c) {
                        case 117: 
                        case 120: {
                            st = 7;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (c < cb) {
                        return false;
                    }
                    h.rangedChar(cb, c);
                    st = 1;
                    continue;
                }
                if (st != 7) continue;
                if (pt + 2 >= s.length()) {
                    return false;
                }
                b.append((char)c);
                b.append(s.charAt(pt++));
                b.append(s.charAt(pt++));
                b.append(s.charAt(pt++));
                try {
                    cz = Integer.parseInt(b.toString(), 16);
                    if (cz >= cb) break block35;
                    return false;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            h.rangedChar(cb, cz);
            b.delete(0, b.length());
            st = 1;
        }
        if (st == 4) {
            h.singleChar(cb);
        }
        return true;
    }

    public static IntRange parse(CharSequence s) {
        final IntRange[] ra = new IntRange[]{IntRange.O};
        boolean r = UnixCharSets.parse(s, new CharSetHandler(){

            public void singleChar(int ch) {
                ra[0] = ra[0].join(UnixCharSets.getintv(ch, ch));
            }

            public void rangedChar(int cb, int ce) {
                ra[0] = ra[0].join(UnixCharSets.getintv(cb, ce));
            }
        });
        if (!r) {
            throw new UnixCharSetException();
        }
        return ra[0];
    }

    static interface CharSetHandler {
        public void singleChar(int var1);

        public void rangedChar(int var1, int var2);
    }
}

