/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.io.LineWriter;
import net.morilib.awk.io.PrintLineWriter;
import net.morilib.awk.misc.System2;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwkPrint
extends AwkExpression {
    private static final AwkValue TWO = AwkInteger.valueOf(2L);
    public static final int OVERWRITE = 0;
    public static final int APPEND = 1;
    public static final int PIPE = 2;
    AwkExpression[] exprs;
    AwkExpression filename;
    int flag;

    public AwkPrint(AwkExpression filename, List<AwkExpression> exprs, int flag) {
        this.filename = filename;
        this.exprs = exprs.toArray(new AwkExpression[0]);
        this.flag = flag;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles f) {
        String ofs = ns.getOFS();
        String ors = ns.getORS();
        StringWriter x = null;
        LineWriter w = null;
        try {
            if (this.filename == null) {
                w = f.getStdout();
            } else {
                AwkValue g = this.filename.eval(ns, f);
                if (g.equals(TWO)) {
                    w = f.getStderr();
                } else if (g.equals(AwkInteger.ONE)) {
                    w = f.getStdout();
                } else {
                    if (!g.isString()) {
                        throw new AwkCastException("string, 1 or 2 required");
                    }
                    if (this.flag == 1) {
                        w = f.getWriter(this.filename.eval(ns, f).toString(ns));
                    } else if (this.flag == 2) {
                        x = new StringWriter();
                        w = new PrintLineWriter(new PrintWriter(x));
                    } else {
                        w = f.openWriter(this.filename.eval(ns, f).toString(ns));
                    }
                }
            }
            if (this.exprs.length == 0) {
                w.print(ns.referField(0).toString(ns));
                w.print(ors);
            } else {
                int i = 0;
                while (i < this.exprs.length) {
                    w.print(this.exprs[i].eval(ns, f).toString(ns));
                    w.print(i + 1 < this.exprs.length ? ofs : ors);
                    ++i;
                }
            }
            w.flush();
            if (x != null) {
                System2.system(this.filename.eval(ns, f).toString(ns), x.toString(), System.out);
            }
            AwkValue awkValue = AwkValue.TRUE;
            return awkValue;
        }
        catch (IOException e1) {
            ns.getRoot().assign("ERRNO", AwkString.valueOf(e1.getMessage()));
            AwkValue awkValue = AwkValue.FALSE;
            return awkValue;
        }
        finally {
            if (w != null) {
                w.flush();
            }
        }
    }
}

