/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.dc.DcCommand;
import net.morilib.dc.DcMath;
import net.morilib.dc.DcModel;
import net.morilib.dc.DcParser;
import net.morilib.dc.DcQuitSignalException;
import net.morilib.dc.DcReader;
import net.morilib.dc.DcSyntaxException;
import net.morilib.dc.Polynomial1Solver;
import net.morilib.dc.number.PiMachinSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DcInterpreter {
    static final char SCALE = '\uff03';
    static final char IBASE = '\uff04';
    static final char OBASE = '\uff05';
    static final char ROUND = '\uff06';
    static final DcC PRINT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            Object o = env.pop();
            env.println(o);
            env.push(o);
        }
    };
    static final DcC PRINT2 = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            Object o = env.pop();
            env.print(o);
        }
    };
    static final DcC PRINT_BYTE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            Object o = env.pop();
            env.printAsByte(o);
        }
    };
    static final DcC PRINT_STACK = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.printStackTrace();
        }
    };
    static final DcC ADD = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.push(a.add(b));
        }
    };
    static final DcC SUB = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.push(a.subtract(b));
        }
    };
    static final DcC MUL = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.push(a.multiply(b));
        }
    };
    static final DcC DIV = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = ((BigDecimal)env.pop()).setScale(env.getScale(), env.getRoundingMode());
            BigDecimal a = ((BigDecimal)env.pop()).setScale(env.getScale(), env.getRoundingMode());
            DcInterpreter.parseDiv(p, env, a, b);
        }
    };
    static final DcC REM = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = ((BigDecimal)env.pop()).setScale(env.getScale(), env.getRoundingMode());
            BigDecimal a = ((BigDecimal)env.pop()).setScale(env.getScale(), env.getRoundingMode());
            DcInterpreter.parseMod(p, env, a, b);
        }
    };
    static final DcC MOD = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            BigDecimal d = a.remainder(b);
            if (d.signum() < 0) {
                d = d.add(b);
            }
            env.push(d);
        }
    };
    static final DcC DIV_REM = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = ((BigDecimal)env.pop()).setScale(env.getScale(), env.getRoundingMode());
            BigDecimal a = ((BigDecimal)env.pop()).setScale(env.getScale(), env.getRoundingMode());
            DcInterpreter.parseDiv(p, env, a, b);
            DcInterpreter.parseMod(p, env, a, b);
        }
    };
    static final DcC POW = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            int z = b.intValue();
            if (z < 0) {
                env.pushConst(1);
                env.push(a.pow(-z));
                b = (BigDecimal)env.pop();
                a = (BigDecimal)env.pop();
                env.push(a.divide(b, env.getRoundingMode()));
            } else {
                env.push(a.pow(z));
            }
        }
    };
    static final DcC POW_MOD = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal c = (BigDecimal)env.pop();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            int z = b.intValue();
            if (z < 0) {
                throw new ArithmeticException();
            }
            if (z == 0) {
                env.pushConst(1);
            } else if (z == 1) {
                env.push(a);
            } else {
                int i = 2;
                while (i < z) {
                    a = a.multiply(a).remainder(c);
                    ++i;
                }
                env.push(a);
            }
        }
    };
    static final DcC SQRT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal a = (BigDecimal)env.pop();
            env.push(DcMath.sqrt(a.setScale(env.getScale())));
        }
    };
    static final DcC CLEAR = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.clear();
        }
    };
    static final DcC DUP = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.duplicate();
        }
    };
    static final DcC EXCHANGE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.exchange();
        }
    };
    static final DcC SETREG = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            Object o = env.pop();
            if (c == 65283 && o instanceof BigDecimal) {
                int x = ((BigDecimal)o).intValue();
                if (x >= 0) {
                    env.setScale(x);
                }
            } else {
                if (c == 960) {
                    throw new DcSyntaxException();
                }
                if (c == 65286) {
                    throw new DcSyntaxException();
                }
                env.set(c, o);
            }
        }
    };
    static final DcC GETREG = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            if (c == 65283) {
                env.pushConst(env.getScale());
            } else if (c == 960) {
                env.push(PiMachinSeries.getPi(env.getScale(), env.getRoundingMode()));
            } else if (c == 65286) {
                env.push(env.getRoundingMode().toString());
            } else {
                env.push(env.peek(c));
            }
        }
    };
    static final DcC PUSHREG = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            Object o = env.pop();
            env.push(c, o);
        }
    };
    static final DcC POPREG = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            env.push(env.pop(c));
        }
    };
    static final DcC SET_I_RADIX = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal d = (BigDecimal)env.pop();
            env.setInputRadix(d.intValueExact());
        }
    };
    static final DcC GET_I_RADIX = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.pushConst(env.getInputRadix());
        }
    };
    static final DcC SET_O_RADIX = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal d = (BigDecimal)env.pop();
            env.setOutputRadix(d.intValueExact());
        }
    };
    static final DcC GET_O_RADIX = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.pushConst(env.getOutputRadix());
        }
    };
    static final DcC SET_SCALE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal d = (BigDecimal)env.pop();
            env.setScale(d.intValueExact());
        }
    };
    static final DcC GET_SCALE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            env.pushConst(env.getScale());
        }
    };
    static final DcC CHR_STR = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            Object o = env.pop();
            if (o instanceof BigDecimal) {
                env.push(String.format("%c", Character.valueOf((char)((BigDecimal)o).intValue())));
            } else if (o instanceof String && !o.equals("")) {
                env.push(((String)o).subSequence(0, 1));
            } else {
                env.push(o);
            }
        }
    };
    static final DcC EXEC_MACRO = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            Object o = env.pop();
            rd.pushStringAsReader(o.toString());
        }
    };
    static final DcC EXEC_LT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            String m = env.peek(c).toString();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.compareTo(b) < 0) {
                rd.pushStringAsReader(m);
            }
        }
    };
    static final DcC EXEC_GE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            String m = env.peek(c).toString();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.compareTo(b) >= 0) {
                rd.pushStringAsReader(m);
            }
        }
    };
    static final DcC EXEC_GT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            String m = env.peek(c).toString();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.compareTo(b) > 0) {
                rd.pushStringAsReader(m);
            }
        }
    };
    static final DcC EXEC_LE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            String m = env.peek(c).toString();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.compareTo(b) <= 0) {
                rd.pushStringAsReader(m);
            }
        }
    };
    static final DcC EXEC_EQ = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            String m = env.peek(c).toString();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.compareTo(b) == 0) {
                rd.pushStringAsReader(m);
            }
        }
    };
    static final DcC EXEC_NE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            String m = env.peek(c).toString();
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.compareTo(b) != 0) {
                rd.pushStringAsReader(m);
            }
        }
    };
    static final DcC READ_MACRO = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            String o = env.readLine();
            rd.pushStringAsReader(o.toString());
        }
    };
    static final DcC QUIT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            if (rd.getLevel() <= 0) {
                throw new DcQuitSignalException();
            }
            rd.pop();
        }
    };
    static final DcC QUIT_N = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int n = ((BigDecimal)env.pop()).intValueExact();
            int i = 0;
            while (i < n && rd.getLevel() >= 0) {
                rd.pop();
                ++i;
            }
        }
    };
    static final DcC LENGTH = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            Object o = env.pop();
            if (o instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)o;
                int s = Math.abs(d.stripTrailingZeros().precision());
                env.pushConst(s);
            } else {
                env.pushConst(o.toString().length());
            }
        }
    };
    static final DcC LENGTH_2 = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            Object o = env.pop();
            if (o instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)o;
                env.pushConst(d.stripTrailingZeros().scale());
            } else {
                env.pushConst(0);
            }
        }
    };
    static final DcC DEPTH = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            int d = env.getDepthOfStack();
            env.pushConst(d);
        }
    };
    static final DcC SETROUND = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            try {
                RoundingMode m = RoundingMode.valueOf(env.pop().toString().toUpperCase());
                env.setRoundingMode(m);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    static final DcC L_NOT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            env.pushConst(b.signum() != 0 ? 0 : 1);
        }
    };
    static final DcC L_AND = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.signum() != 0 && b.signum() != 0 ? 1 : 0);
        }
    };
    static final DcC L_OR = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.signum() != 0 || b.signum() != 0 ? 1 : 0);
        }
    };
    static final DcC L_LT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.compareTo(b) < 0 ? 1 : 0);
        }
    };
    static final DcC L_LE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.compareTo(b) <= 0 ? 1 : 0);
        }
    };
    static final DcC L_GT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.compareTo(b) > 0 ? 1 : 0);
        }
    };
    static final DcC L_GE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.compareTo(b) >= 0 ? 1 : 0);
        }
    };
    static final DcC L_EQ = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.compareTo(b) == 0 ? 1 : 0);
        }
    };
    static final DcC L_NE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) {
            BigDecimal b = (BigDecimal)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            env.pushConst(a.compareTo(b) != 0 ? 1 : 0);
        }
    };
    static final DcC EXEC_TRI = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            String c = (String)env.pop();
            String b = (String)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.signum() != 0) {
                rd.pushStringAsReader(b);
            } else {
                rd.pushStringAsReader(c);
            }
        }
    };
    static final DcC HALT = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            throw new DcQuitSignalException();
        }
    };
    static final DcC POP = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            env.pop();
        }
    };
    static final DcC PRINTALL = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            ArrayList<String> l = new ArrayList<String>();
            int x = ((BigDecimal)env.pop()).intValue();
            int i = 0;
            while (i < x) {
                l.add(env.pop().toString());
                ++i;
            }
            i = l.size() - 1;
            while (i >= 0) {
                env.print(l.get(i));
                --i;
            }
        }
    };
    static final DcC IRR = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            double y = Double.POSITIVE_INFINITY;
            int x = ((BigDecimal)env.pop()).intValue();
            double[] d = new double[x];
            int i = 0;
            while (i < x) {
                d[i] = ((BigDecimal)env.pop()).doubleValue();
                ++i;
            }
            double[] f = Polynomial1Solver.solveAll(d);
            i = 0;
            while (i < f.length) {
                if (Math.abs(f[i] - 1.0) < y) {
                    y = Math.abs(f[i] - 1.0);
                }
                ++i;
            }
            if (Double.isInfinite(y)) {
                throw new ArithmeticException();
            }
            BigDecimal a = BigDecimal.valueOf(y);
            a = a.setScale(2, env.getRoundingMode());
            env.push(a);
        }
    };
    static final DcC TENTOTHE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int x = ((BigDecimal)env.pop()).intValue();
            env.push(BigDecimal.ONE.scaleByPowerOfTen(x));
        }
    };
    static final DcC ERROR = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            throw new ArithmeticException(env.pop().toString());
        }
    };
    static final DcC EXEC_MACRO2 = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            Object o = env.pop();
            rd.pushOrSetStringAsReader(o.toString());
        }
    };
    static final DcC EXEC_TRI2 = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            String c = (String)env.pop();
            String b = (String)env.pop();
            BigDecimal a = (BigDecimal)env.pop();
            if (a.signum() != 0) {
                rd.pushOrSetStringAsReader(b);
            } else {
                rd.pushOrSetStringAsReader(c);
            }
        }
    };
    static final DcC SET_ARRAY = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            Object a = env.pop();
            Object b = env.pop();
            env.setArray(c, a, b);
        }
    };
    static final DcC GET_ARRAY = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            Object a = env.pop();
            env.push(env.getArray(c, a));
        }
    };
    static final DcC VARARGS = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            env.clearArray(c);
            int b = ((BigDecimal)env.pop()).intValue();
            int a = ((BigDecimal)env.pop()).intValue();
            int i = a - 1;
            while (i >= b) {
                env.setArray(c, BigDecimal.valueOf(i - b), env.pop());
                --i;
            }
        }
    };
    static final DcC SIZE = new DcC(){

        @Override
        public void parse(DcParser<DcModel> p, DcModel env, DcReader rd, boolean tail) throws IOException {
            int c = rd.read();
            if (c < 0) {
                throw new DcSyntaxException();
            }
            env.pushConst(env.getArraySize(c));
        }
    };

    private static void parseDiv(DcParser<DcModel> p, DcModel env, BigDecimal a, BigDecimal b) {
        BigDecimal d = a.divide(b, env.getRoundingMode());
        env.push(d.stripTrailingZeros());
    }

    private static void parseMod(DcParser<DcModel> p, DcModel env, BigDecimal a, BigDecimal b) {
        BigDecimal x = a.setScale(env.getScale(), env.getRoundingMode());
        BigDecimal y = b.setScale(env.getScale(), env.getRoundingMode());
        BigDecimal d = x.divide(y, env.getRoundingMode());
        int s = Math.max(env.getScale() + b.scale(), a.scale());
        BigDecimal q = a.setScale(s, env.getRoundingMode());
        BigDecimal r = d.setScale(s, env.getRoundingMode());
        BigDecimal t = b.setScale(s, env.getRoundingMode());
        BigDecimal z = q.subtract(r.multiply(t));
        env.push(z.stripTrailingZeros().setScale(env.getScale()));
    }

    public static Map<Character, DcCommand<DcModel>> getInstance() {
        HashMap<Character, DcC> r = new HashMap<Character, DcC>();
        r.put(Character.valueOf('p'), PRINT);
        r.put(Character.valueOf('n'), PRINT2);
        r.put(Character.valueOf('P'), PRINT_BYTE);
        r.put(Character.valueOf('f'), PRINT_STACK);
        r.put(Character.valueOf('+'), ADD);
        r.put(Character.valueOf('-'), SUB);
        r.put(Character.valueOf('*'), MUL);
        r.put(Character.valueOf('/'), DIV);
        r.put(Character.valueOf('%'), REM);
        r.put(Character.valueOf('~'), DIV_REM);
        r.put(Character.valueOf('^'), POW);
        r.put(Character.valueOf('|'), POW_MOD);
        r.put(Character.valueOf('v'), SQRT);
        r.put(Character.valueOf('c'), CLEAR);
        r.put(Character.valueOf('d'), DUP);
        r.put(Character.valueOf('r'), EXCHANGE);
        r.put(Character.valueOf('s'), SETREG);
        r.put(Character.valueOf('l'), GETREG);
        r.put(Character.valueOf('S'), PUSHREG);
        r.put(Character.valueOf('L'), POPREG);
        r.put(Character.valueOf('i'), SET_I_RADIX);
        r.put(Character.valueOf('I'), GET_I_RADIX);
        r.put(Character.valueOf('o'), SET_O_RADIX);
        r.put(Character.valueOf('O'), GET_O_RADIX);
        r.put(Character.valueOf('k'), SET_SCALE);
        r.put(Character.valueOf('K'), GET_SCALE);
        r.put(Character.valueOf('a'), CHR_STR);
        r.put(Character.valueOf('x'), EXEC_MACRO);
        r.put(Character.valueOf('<'), EXEC_LT);
        r.put(Character.valueOf('>'), EXEC_GT);
        r.put(Character.valueOf('='), EXEC_EQ);
        r.put(Character.valueOf('\u5c0f'), EXEC_LE);
        r.put(Character.valueOf('\u5927'), EXEC_GE);
        r.put(Character.valueOf('\u4e0d'), EXEC_NE);
        r.put(Character.valueOf('?'), READ_MACRO);
        r.put(Character.valueOf('q'), QUIT);
        r.put(Character.valueOf('Q'), QUIT_N);
        r.put(Character.valueOf('Z'), LENGTH);
        r.put(Character.valueOf('X'), LENGTH_2);
        r.put(Character.valueOf('z'), DEPTH);
        r.put(Character.valueOf(':'), SET_ARRAY);
        r.put(Character.valueOf(';'), GET_ARRAY);
        r.put(Character.valueOf('R'), SETROUND);
        r.put(Character.valueOf('N'), L_NOT);
        r.put(Character.valueOf('\uff06'), L_AND);
        r.put(Character.valueOf('\uff5c'), L_OR);
        r.put(Character.valueOf('\uff1c'), L_LT);
        r.put(Character.valueOf('\u2266'), L_LE);
        r.put(Character.valueOf('\uff1e'), L_GT);
        r.put(Character.valueOf('\u2267'), L_GE);
        r.put(Character.valueOf('\uff1d'), L_EQ);
        r.put(Character.valueOf('\u2260'), L_NE);
        r.put(Character.valueOf('\uff1f'), EXEC_TRI);
        r.put(Character.valueOf('\u5237'), PRINTALL);
        r.put(Character.valueOf('\u505c'), HALT);
        r.put(Character.valueOf('\u6368'), POP);
        r.put(Character.valueOf('\u5229'), IRR);
        r.put(Character.valueOf('\u4e07'), TENTOTHE);
        r.put(Character.valueOf('\u8aa4'), ERROR);
        r.put(Character.valueOf('\u6cd5'), MOD);
        r.put(Character.valueOf('\u8d70'), EXEC_MACRO2);
        r.put(Character.valueOf('\u5c90'), EXEC_TRI2);
        r.put(Character.valueOf('\u5909'), VARARGS);
        r.put(Character.valueOf('\u6570'), SIZE);
        return Collections.unmodifiableMap(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface DcC
    extends DcCommand<DcModel> {
    }
}

