/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc.number;

import java.util.Iterator;
import net.morilib.dc.number.Integer2;
import net.morilib.dc.number.Rational;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternatingSeriesNumber
extends Number {
    protected Rational scale;
    protected Rational shift;
    protected Iterable<Rational> iterable;
    private transient double pitmp = Double.NaN;
    private transient long pitmpl = 0L;
    private transient Integer2 pitmpb = null;

    public AlternatingSeriesNumber(Iterable<Rational> iterable, Rational scale, Rational shift) {
        if (scale.isZero()) {
            throw new IllegalArgumentException();
        }
        this.iterable = iterable;
        this.scale = scale;
        this.shift = shift;
    }

    public AlternatingSeriesNumber(long scale) {
        if (scale == 0L) {
            throw new IllegalArgumentException();
        }
        this.scale = Rational.valueOf(scale);
    }

    Rational _next(Iterator<Rational> itr) {
        return itr.next().multiply(this.scale).add(this.shift);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double doubleValue() {
        if (Double.isNaN(this.pitmp)) {
            AlternatingSeriesNumber alternatingSeriesNumber = this;
            synchronized (alternatingSeriesNumber) {
                Iterator<Rational> itr = this.iterable.iterator();
                double t = this.pitmp;
                while (t != this.pitmp) {
                    this.pitmp = t;
                    t = this._next(itr).doubleValue();
                }
            }
        }
        return this.pitmp;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.pitmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long longValue() {
        if (this.pitmpl == 0L) {
            AlternatingSeriesNumber alternatingSeriesNumber = this;
            synchronized (alternatingSeriesNumber) {
                Iterator<Rational> itr = this.iterable.iterator();
                long t = this.pitmpl;
                while (t != this.pitmpl) {
                    t = this._next(itr).castLong();
                    t = this.pitmpl;
                }
            }
        }
        return this.pitmpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer2 toInteger2() {
        if (this.pitmpb == null) {
            AlternatingSeriesNumber alternatingSeriesNumber = this;
            synchronized (alternatingSeriesNumber) {
                Iterator<Rational> itr = this.iterable.iterator();
                Integer2 t = this.pitmpb;
                while (!t.equals(this.pitmpb)) {
                    t = this._next(itr).castInteger2();
                    t = this.pitmpb;
                }
            }
        }
        return this.pitmpb;
    }

    public Rational getScale() {
        return this.scale;
    }

    public Rational getShift() {
        return this.shift;
    }

    public int signum() {
        return this.compareTo(Rational.ZERO);
    }

    public AlternatingSeriesNumber negate() {
        return new AlternatingSeriesNumber(this.iterable, this.scale.negate(), this.shift.negate());
    }

    public int compareTo(Rational n) {
        Iterator<Rational> itr = this.iterable.iterator();
        do {
            if (this._next(itr).compareTo(n) >= 0) continue;
            return -1;
        } while (this._next(itr).compareTo(n) <= 0);
        return 1;
    }

    public int compareTo(AlternatingSeriesNumber n) {
        Rational jb;
        Rational ia;
        Iterator<Rational> itr = this.iterable.iterator();
        Iterator<Rational> jtr = n.iterable.iterator();
        do {
            Rational i1 = this._next(itr);
            Rational i2 = this._next(itr);
            Rational j1 = n._next(jtr);
            Rational j2 = n._next(jtr);
            ia = i1.compareTo(i2) > 0 ? i1 : i2;
            Rational ib = i1.compareTo(i2) > 0 ? i2 : i1;
            Rational ja = j1.compareTo(j2) > 0 ? j1 : j2;
            Rational rational = jb = j1.compareTo(j2) > 0 ? j2 : j1;
            if (ib.compareTo(ja) <= 0) continue;
            return 1;
        } while (ia.compareTo(jb) >= 0);
        return -1;
    }
}

