/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.bytes;

import net.morilib.awk.bytes.AbstractByteSet;
import net.morilib.awk.bytes.BitSet2;
import net.morilib.awk.bytes.BitSet2Class;
import net.morilib.awk.bytes.ByteCollection;
import net.morilib.awk.bytes.ByteCollections;
import net.morilib.awk.bytes.ByteIterator;
import net.morilib.awk.bytes.ByteSet;
import net.morilib.awk.bytes.ByteSortedSet;
import net.morilib.awk.misc.IntegerIterator;

public class ByteBitSet
extends AbstractByteSet
implements ByteSortedSet {
    private static final BitSet2Class BYTE_CLS = new BitSet2Class(-128, 127);
    private BitSet2 bits = BYTE_CLS.newInstance();

    public ByteBitSet(ByteCollection a) {
        this.addAllByte(a);
    }

    public boolean addByte(byte v) {
        return this.bits.add(v);
    }

    public boolean addAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.addAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.addAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.addAllByte((ByteCollection)s);
    }

    public void clear() {
        this.bits.clear();
    }

    public boolean containsByte(byte v) {
        return this.bits.contains(v);
    }

    public boolean containsAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.containsAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.containsAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.containsAllByte(s);
    }

    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    public ByteIterator byteIterator() {
        return new Itr(this.bits.iterator());
    }

    public boolean removeByte(byte v) {
        return this.bits.remove(v);
    }

    public boolean removeAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.removeAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.removeAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.removeAllByte(s);
    }

    public boolean retainAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.retainAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.retainAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.retainAllByte(s);
    }

    public int size() {
        return this.bits.size();
    }

    public byte first() {
        return (byte)this.bits.first();
    }

    public ByteSortedSet headSet(byte v) {
        return this.collect(ByteCollections.interval(v, (byte)127));
    }

    public ByteSortedSet subSet(byte s, byte e) {
        if (s > e) {
            throw new IllegalArgumentException();
        }
        return this.collect(ByteCollections.interval(s, e));
    }

    public ByteSortedSet tailSet(byte v) {
        return this.collect(ByteCollections.interval((byte)-128, v));
    }

    public byte last() {
        return (byte)this.bits.last();
    }

    public ByteSortedSet collect(ByteSortedSet set) {
        ByteBitSet r = new ByteBitSet(this);
        r.removeAllByte(set);
        return ByteCollections.unmodifiableSortedSet(r);
    }

    private class Itr
    implements ByteIterator {
        private IntegerIterator itr;

        private Itr(IntegerIterator itr) {
            this.itr = itr;
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public byte next() {
            return (byte)this.itr.next();
        }

        public void remove() {
            this.itr.remove();
        }
    }
}

