/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.namespace;

import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwkSimpleNamespace
implements AwkNamespace {
    protected AwkNamespace root;
    private Map<String, AwkValue> values;
    private Map<String, AwkFunction> functions;
    private Map<String, AwkNamespace> namespaces;

    AwkSimpleNamespace() {
        this.values = new HashMap<String, AwkValue>();
        this.functions = new HashMap<String, AwkFunction>();
        this.namespaces = new HashMap<String, AwkNamespace>();
        this.root = null;
    }

    private AwkSimpleNamespace(Map<String, AwkValue> values, Map<String, AwkFunction> functions, Map<String, AwkNamespace> namespaces, AwkNamespace root) {
        this.values = values;
        this.functions = functions;
        this.namespaces = namespaces;
        this.root = root;
    }

    public AwkSimpleNamespace(AwkNamespace root) {
        this();
        this.root = root;
    }

    @Override
    public void assign(String s, AwkValue v) {
        this.values.put(s, v);
    }

    @Override
    public void assignArgument(String s, AwkValue v) {
        this.values.put(s, v);
    }

    @Override
    public AwkValue find(String s) {
        return this.values.get(s);
    }

    @Override
    public AwkFunction findFunction(String s) {
        return this.functions.get(s);
    }

    @Override
    public void bindFunction(String s, AwkFunction v) {
        this.functions.put(s, v);
    }

    @Override
    public boolean isReadonly(String s) {
        return false;
    }

    @Override
    public synchronized AwkNamespace subnamespace(String s) {
        AwkNamespace ns = this.namespaces.get(s);
        if (ns == null) {
            ns = new AwkSimpleNamespace(this);
            this.namespaces.put(s, ns);
        }
        return ns;
    }

    @Override
    public AwkNamespace referNamespace(String s) {
        return this.namespaces.get(s);
    }

    @Override
    public AwkValue referField(int n) {
        return this.root.referField(n);
    }

    @Override
    public int sizeOfField() {
        return this.root.sizeOfField();
    }

    @Override
    public void setField(String s) {
        this.root.setField(s);
    }

    @Override
    public void setField(int n, String s) {
        this.root.setField(n, s);
    }

    @Override
    public String getFS() {
        return this.root.getFS();
    }

    @Override
    public String getRS() {
        return this.root.getRS();
    }

    @Override
    public String getOFS() {
        return this.root.getOFS();
    }

    @Override
    public String getORS() {
        return this.root.getORS();
    }

    @Override
    public AwkNamespace getRoot() {
        return this.root.getRoot();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public AwkNamespace newInstance() {
        return new AwkSimpleNamespace(new HashMap<String, AwkValue>(this.values), this.functions, this.namespaces, this.root);
    }

    @Override
    public boolean isIgnoreCase() {
        return this.root.isIgnoreCase();
    }
}

