/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import net.morilib.awk.AwkSQLException;
import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkPreparedStatementQueryFunction;
import net.morilib.awk.value.AwkPreparedStatementUpdateFunction;
import net.morilib.awk.value.AwkSQLCloseable;
import net.morilib.awk.value.AwkValue;

public class AwkSQLConnection
extends AwkUnaryArgs
implements AwkSQLCloseable {
    private static final Pattern PS = Pattern.compile("[ \t]*SELECT", 2);
    private Connection connect;

    public AwkSQLConnection(Connection con) {
        super("connection");
        this.connect = con;
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
        try {
            if (PS.matcher(a1.toString()).lookingAt()) {
                return new AwkPreparedStatementQueryFunction(this.connect.prepareStatement(a1.toString()));
            }
            return new AwkPreparedStatementUpdateFunction(this.connect.prepareStatement(a1.toString()));
        }
        catch (SQLException e) {
            throw new AwkSQLException(e);
        }
    }

    public void closeSQL() throws SQLException {
        this.connect.close();
    }
}

