/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.morilib.awk.AwkArithmeticException;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.misc.AwkComplexMath;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkComplex;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AwkValue {
    private static final BigInteger MINB = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAXB = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final AwkValue TRUE = AwkInteger.valueOf(1L);
    public static final AwkValue FALSE = AwkInteger.valueOf(0L);
    public static final AwkValue IOERROR = AwkInteger.valueOf(-1L);

    public BigInteger toInteger() {
        return BigInteger.ZERO;
    }

    public int toIntExact() {
        if (!this.isIntValue()) {
            throw new AwkArithmeticException("the integer is not small");
        }
        return this.toInteger().intValue();
    }

    public double toFloat() {
        return 0.0;
    }

    public double toImaginary() {
        return 0.0;
    }

    public abstract String toString(AwkNamespace var1);

    public String toString() {
        return this.toString(null);
    }

    public abstract boolean toBoolean(AwkNamespace var1);

    public Number toReal() {
        throw new AwkCastException(this + " is not a number");
    }

    public AwkValue toNumber() {
        throw new AwkCastException(this + " is not a number");
    }

    public Pattern toRegex(AwkNamespace ns) {
        if (ns.isIgnoreCase()) {
            return Pattern.compile(this.toString(ns), 2);
        }
        return Pattern.compile(this.toString(ns));
    }

    public AwkArray toArray() {
        throw new AwkCastException(this + " is not an array");
    }

    public abstract Object toObject();

    public AwkValue referArray(String v) {
        throw new AwkCastException(this + " is not an array");
    }

    public AwkValue putArray(String k, AwkValue v) {
        throw new AwkCastException(this + " is not an array");
    }

    public boolean contains(String k) {
        throw new AwkCastException(this + " is not an array");
    }

    public AwkValue deleteArray(String v) {
        throw new AwkCastException(this + " is not an array");
    }

    public Set<String> keys() {
        throw new AwkCastException(this + " is not an array");
    }

    public Collection<AwkValue> values() {
        throw new AwkCastException(this + " is not an array");
    }

    public Iterator<AwkValue> iterator() {
        throw new AwkCastException(this + " is not an iterator");
    }

    public Set<Map.Entry<String, AwkValue>> entrySet() {
        throw new AwkCastException(this + " is not an array");
    }

    public Map<String, AwkValue> map() {
        throw new AwkCastException(this + " is not an array");
    }

    public void clear() {
        throw new AwkCastException(this + " is not an array");
    }

    public int size() {
        return 1;
    }

    public abstract boolean isInteger();

    public abstract boolean isFloat();

    public abstract boolean isReal();

    public abstract boolean isIntegerValue();

    public boolean isIntValue() {
        return this.isIntegerValue() && this.toInteger().compareTo(MINB) > 0 && this.toInteger().compareTo(MAXB) < 0;
    }

    public abstract boolean isFloatValue();

    public abstract boolean isRealValue();

    public abstract boolean isPositiveValue();

    public abstract boolean isZeroValue();

    public abstract boolean isNegativeValue();

    public abstract boolean isString();

    public abstract boolean isRegex();

    public abstract boolean isFunction();

    public boolean isEmpty() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public AwkNamespace getNamespace() {
        return null;
    }

    public abstract int compareTo(AwkValue var1, AwkNamespace var2);

    public static AwkValue cast(String s) {
        try {
            return AwkInteger.valueOf(new BigInteger(s));
        }
        catch (NumberFormatException e1) {
            try {
                return AwkFloat.valueOf(Double.parseDouble(s));
            }
            catch (NumberFormatException e2) {
                return AwkString.valueOf(s);
            }
        }
    }

    public boolean isComplex() {
        return false;
    }

    public boolean isNaN() {
        return false;
    }

    public boolean isOne() {
        return this.toImaginary() == 0.0 && (this.toInteger().equals(BigInteger.ONE) || this.toFloat() == 1.0);
    }

    public boolean isNumber() {
        return false;
    }

    public static AwkValue add(AwkValue r1, AwkValue r2) {
        if (r1 instanceof AwkUndefined) {
            return r2;
        }
        if (r2 instanceof AwkUndefined) {
            return r1;
        }
        if (r1.isArray() && r2.isArray()) {
            AwkArray r0 = new AwkArray(r1);
            for (Map.Entry<String, AwkValue> e : r2.entrySet()) {
                String s = e.getKey();
                if (r1.contains(s)) {
                    r0.putArray(s, AwkValue.add(r1.referArray(s), e.getValue()));
                    continue;
                }
                r0.putArray(s, e.getValue());
            }
            return r0;
        }
        if (r1.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.add(z.getValue(), r2));
            }
            return r0;
        }
        if (r2.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.add(r1, z.getValue()));
            }
            return r0;
        }
        if (r1.isInteger() && r2.isInteger()) {
            return AwkInteger.valueOf(r1.toInteger().add(r2.toInteger()));
        }
        if (r1.isNumber() && r2.isNumber()) {
            return AwkComplex.valueOf(r1.toFloat() + r2.toFloat(), r1.toImaginary() + r2.toImaginary());
        }
        return AwkValue.add(r1.toNumber(), r2.toNumber());
    }

    public static AwkValue sub(AwkValue r1, AwkValue r2) {
        if (r1 instanceof AwkUndefined) {
            return AwkValue.sub(AwkInteger.ZERO, r2);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.sub(r1, AwkInteger.ZERO);
        }
        if (r1.isArray() && r2.isArray()) {
            AwkArray r0 = new AwkArray(r1);
            for (Map.Entry<String, AwkValue> e : r2.entrySet()) {
                String s = e.getKey();
                if (r1.contains(s)) {
                    r0.putArray(s, AwkValue.sub(r1.referArray(s), e.getValue()));
                    continue;
                }
                r0.putArray(s, AwkValue.neg(e.getValue()));
            }
            return r0;
        }
        if (r1.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.sub(z.getValue(), r2));
            }
            return r0;
        }
        if (r2.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.sub(r1, z.getValue()));
            }
            return r0;
        }
        if (r1.isInteger() && r2.isInteger()) {
            return AwkInteger.valueOf(r1.toInteger().subtract(r2.toInteger()));
        }
        if (r1.isNumber() && r2.isNumber()) {
            return AwkComplex.valueOf(r1.toFloat() - r2.toFloat(), r1.toImaginary() - r2.toImaginary());
        }
        return AwkValue.sub(r1.toNumber(), r2.toNumber());
    }

    public static AwkValue mul(AwkValue r1, AwkValue r2) {
        if (r1 instanceof AwkUndefined) {
            return AwkValue.mul(AwkInteger.ZERO, r2);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.mul(r1, AwkInteger.ZERO);
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray r0 = new AwkArray(r1);
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    r0.putArray(s, AwkValue.mul(r1.referArray(s), z.getValue()));
                    continue;
                }
                if (z.getValue().isFloat()) {
                    r0.putArray(s, AwkFloat.valueOf(0.0));
                    continue;
                }
                r0.putArray(s, AwkInteger.ZERO);
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                r0.putArray(s, AwkInteger.ZERO);
            }
            return r0;
        }
        if (r1.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.mul(z.getValue(), r2));
            }
            return r0;
        }
        if (r2.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.mul(r1, z.getValue()));
            }
            return r0;
        }
        if (r1.isInteger() && r2.isInteger()) {
            return AwkInteger.valueOf(r1.toInteger().multiply(r2.toInteger()));
        }
        if (r1.isNumber() && r2.isNumber()) {
            double a = r1.toFloat();
            double b = r1.toImaginary();
            double c = r2.toFloat();
            double d = r2.toImaginary();
            return AwkComplex.valueOf(a * c - b * d, b * c + a * d);
        }
        return AwkValue.mul(r1.toNumber(), r2.toNumber());
    }

    public static AwkValue div(AwkValue r1, AwkValue r2) {
        block18: {
            if (r1 instanceof AwkUndefined) {
                return AwkValue.div(AwkInteger.ZERO, r2);
            }
            if (r2 instanceof AwkUndefined) {
                return AwkValue.div(r1, AwkInteger.ZERO);
            }
            if (r1.isArray() && r2.isArray()) {
                String s;
                AwkArray r0 = new AwkArray(r1);
                for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                    s = z.getKey();
                    if (r1.contains(s)) {
                        r0.putArray(s, AwkValue.div(r1.referArray(s), z.getValue()));
                        continue;
                    }
                    if (z.getValue().isFloat()) {
                        r0.putArray(s, AwkFloat.valueOf(0.0));
                        continue;
                    }
                    r0.putArray(s, AwkInteger.ZERO);
                }
                for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                    s = z.getKey();
                    if (r2.contains(s)) continue;
                    if (z.getValue().isPositiveValue()) {
                        r0.putArray(s, AwkFloat.valueOf(Double.POSITIVE_INFINITY));
                        continue;
                    }
                    r0.putArray(s, AwkFloat.valueOf(Double.NEGATIVE_INFINITY));
                }
                return r0;
            }
            if (r1.isArray()) {
                AwkArray r0 = new AwkArray();
                for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                    String s = z.getKey();
                    r0.putArray(s, AwkValue.div(z.getValue(), r2));
                }
                return r0;
            }
            if (r2.isArray()) {
                AwkArray r0 = new AwkArray();
                for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                    String s = z.getKey();
                    r0.putArray(s, AwkValue.div(r1, z.getValue()));
                }
                return r0;
            }
            if (r1.isInteger() && r2.isInteger()) {
                try {
                    BigInteger e = r1.toInteger();
                    BigInteger f = r2.toInteger();
                    BigInteger[] g = e.divideAndRemainder(f);
                    if (g[1].signum() == 0) {
                        return AwkInteger.valueOf(g[0]);
                    }
                    break block18;
                }
                catch (ArithmeticException z) {
                    throw new AwkArithmeticException(z.getMessage());
                }
            }
            if (r1.isFloat() || r2.isFloat()) {
                return AwkFloat.valueOf(r1.toFloat() / r2.toFloat());
            }
            if (!r1.isNumber() || !r2.isNumber()) {
                return AwkValue.div(r1.toNumber(), r2.toNumber());
            }
        }
        double a = r1.toFloat();
        double b = r1.toImaginary();
        double c = r2.toFloat();
        double d = r2.toImaginary();
        double n = c * c + d * d;
        return AwkComplex.valueOf((a * c + b * d) / n, (b * c - a * d) / n);
    }

    public static AwkValue pow(AwkValue r1, AwkValue r2) {
        if (r1 instanceof AwkUndefined && r2 instanceof AwkUndefined) {
            throw new ArithmeticException();
        }
        if (r1 instanceof AwkUndefined) {
            return AwkValue.pow(AwkInteger.ZERO, r2);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.pow(r1, AwkInteger.ZERO);
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray r0 = new AwkArray(r1);
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    r0.putArray(s, AwkValue.pow(r1.referArray(s), z.getValue()));
                    continue;
                }
                r0.putArray(s, AwkValue.pow(AwkInteger.ZERO, z.getValue()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                r0.putArray(s, AwkValue.pow(z.getValue(), AwkInteger.ZERO));
            }
            return r0;
        }
        if (r1.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.pow(z.getValue(), r2));
            }
            return r0;
        }
        if (r2.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.pow(r1, z.getValue()));
            }
            return r0;
        }
        if (!r1.isNumber() || !r2.isNumber()) {
            return AwkValue.pow(r1.toNumber(), r2.toNumber());
        }
        return AwkComplexMath.expt(r1, r2);
    }

    public static AwkValue neg(AwkValue v) {
        if (v.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : v.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.neg(z.getValue()));
            }
            return r0;
        }
        if (v.isInteger()) {
            return AwkInteger.valueOf(v.toInteger().negate());
        }
        if (!v.isNumber()) {
            return AwkValue.neg(v.toNumber());
        }
        return AwkComplex.valueOf(-v.toFloat(), -v.toImaginary());
    }

    public static AwkValue concat(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            return r2;
        }
        if (r2 instanceof AwkUndefined) {
            return r1;
        }
        if (r1.isArray() && r2.isArray()) {
            AwkArray r0 = new AwkArray(r1);
            for (Map.Entry<String, AwkValue> e : r2.entrySet()) {
                String s = e.getKey();
                if (r1.contains(s)) {
                    r0.putArray(s, AwkValue.concat(r1.referArray(s), e.getValue(), ns));
                    continue;
                }
                r0.putArray(s, e.getValue());
            }
            return r0;
        }
        if (r1.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.concat(z.getValue(), r2, ns));
            }
            return r0;
        }
        if (r2.isArray()) {
            AwkArray r0 = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                r0.putArray(s, AwkValue.concat(r1, z.getValue(), ns));
            }
            return r0;
        }
        return AwkString.valueOf(String.valueOf(r1.toString(ns)) + r2.toString(ns));
    }

    public static AwkValue equals(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            AwkArray a = new AwkArray();
            if (r2.isArray()) {
                for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                    a.putArray(z.getKey(), AwkInteger.booleanOf(z.getValue().isEmpty()));
                }
                return a;
            }
            return AwkInteger.booleanOf(r2.isEmpty());
        }
        if (r2 instanceof AwkUndefined) {
            AwkArray a = new AwkArray();
            if (r1.isArray()) {
                for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                    a.putArray(z.getKey(), AwkInteger.booleanOf(z.getValue().isEmpty()));
                }
                return a;
            }
            return AwkInteger.booleanOf(r1.isEmpty());
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    AwkValue x = AwkValue.equals(r1.referArray(s), z.getValue(), ns);
                    a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
                    continue;
                }
                a.putArray(s, AwkInteger.booleanOf(z.getValue().isEmpty()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                a.putArray(s, AwkInteger.booleanOf(z.getValue().isEmpty()));
            }
            return a;
        }
        if (r1.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.equals(r1.referArray(s), r2, ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        if (r2.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.equals(r1, r2.referArray(s), ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        return AwkInteger.booleanOf(r1.compareTo(r2, ns) == 0);
    }

    public static AwkValue ne(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            AwkArray a = new AwkArray();
            if (r2.isArray()) {
                for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                    a.putArray(z.getKey(), AwkInteger.booleanOf(!z.getValue().isEmpty()));
                }
                return a;
            }
            return AwkInteger.booleanOf(!r2.isEmpty());
        }
        if (r2 instanceof AwkUndefined) {
            AwkArray a = new AwkArray();
            if (r1.isArray()) {
                for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                    a.putArray(z.getKey(), AwkInteger.booleanOf(!z.getValue().isEmpty()));
                }
                return a;
            }
            return AwkInteger.booleanOf(!r1.isEmpty());
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    AwkValue x = AwkValue.ne(r1.referArray(s), z.getValue(), ns);
                    a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
                    continue;
                }
                a.putArray(s, AwkInteger.booleanOf(!z.getValue().isEmpty()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                a.putArray(s, AwkInteger.booleanOf(!z.getValue().isEmpty()));
            }
            return a;
        }
        if (r1.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.ne(r1.referArray(s), r2, ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        if (r2.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.ne(r1, r2.referArray(s), ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        return AwkInteger.booleanOf(r1.compareTo(r2, ns) != 0);
    }

    public static AwkValue lt(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            return AwkValue.lt(AwkInteger.ZERO, r2, ns);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.lt(r1, AwkInteger.ZERO, ns);
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    AwkValue x = AwkValue.lt(r1.referArray(s), z.getValue(), ns);
                    a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
                    continue;
                }
                a.putArray(s, AwkInteger.booleanOf(z.getValue().isPositiveValue()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                a.putArray(s, AwkInteger.booleanOf(z.getValue().isNegativeValue()));
            }
            return a;
        }
        if (r1.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.lt(r1.referArray(s), r2, ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        if (r2.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.lt(r1, r2.referArray(s), ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        return AwkInteger.booleanOf(r1.compareTo(r2, ns) < 0);
    }

    public static AwkValue le(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            return AwkValue.le(AwkInteger.ZERO, r2, ns);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.le(r1, AwkInteger.ZERO, ns);
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    AwkValue x = AwkValue.le(r1.referArray(s), z.getValue(), ns);
                    a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
                    continue;
                }
                a.putArray(s, AwkInteger.booleanOf(!z.getValue().isNegativeValue()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                a.putArray(s, AwkInteger.booleanOf(!z.getValue().isPositiveValue()));
            }
            return a;
        }
        if (r1.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.le(r1.referArray(s), r2, ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        if (r2.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.le(r1, r2.referArray(s), ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        return AwkInteger.booleanOf(r1.compareTo(r2, ns) <= 0);
    }

    public static AwkValue gt(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            return AwkValue.gt(AwkInteger.ZERO, r2, ns);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.gt(r1, AwkInteger.ZERO, ns);
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    AwkValue x = AwkValue.gt(r1.referArray(s), z.getValue(), ns);
                    a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
                    continue;
                }
                a.putArray(s, AwkInteger.booleanOf(z.getValue().isNegativeValue()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                a.putArray(s, AwkInteger.booleanOf(z.getValue().isPositiveValue()));
            }
            return a;
        }
        if (r1.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.gt(r1.referArray(s), r2, ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        if (r2.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.gt(r1, r2.referArray(s), ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        return AwkInteger.booleanOf(r1.compareTo(r2, ns) > 0);
    }

    public static AwkValue ge(AwkValue r1, AwkValue r2, AwkNamespace ns) {
        if (r1 instanceof AwkUndefined) {
            return AwkValue.ge(AwkInteger.ZERO, r2, ns);
        }
        if (r2 instanceof AwkUndefined) {
            return AwkValue.ge(r1, AwkInteger.ZERO, ns);
        }
        if (r1.isArray() && r2.isArray()) {
            String s;
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                s = z.getKey();
                if (r1.contains(s)) {
                    AwkValue x = AwkValue.ge(r1.referArray(s), z.getValue(), ns);
                    a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
                    continue;
                }
                a.putArray(s, AwkInteger.booleanOf(!z.getValue().isPositiveValue()));
            }
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                s = z.getKey();
                if (r2.contains(s)) continue;
                a.putArray(s, AwkInteger.booleanOf(!z.getValue().isNegativeValue()));
            }
            return a;
        }
        if (r1.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r1.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.ge(r1.referArray(s), r2, ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        if (r2.isArray()) {
            AwkArray a = new AwkArray();
            for (Map.Entry<String, AwkValue> z : r2.entrySet()) {
                String s = z.getKey();
                AwkValue x = AwkValue.ge(r1, r2.referArray(s), ns);
                a.putArray(s, AwkInteger.booleanOf(x.toBoolean(ns)));
            }
            return a;
        }
        return AwkInteger.booleanOf(r1.compareTo(r2, ns) >= 0);
    }
}

