/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.morilib.bc.BcExprParser;
import net.morilib.bc.BcLexer;
import net.morilib.bc.BcNamespace;
import net.morilib.bc.BcQuitException;
import net.morilib.bc.BcStringLiteral;
import net.morilib.bc.BcSyntaxException;
import net.morilib.dc.DcDefaultModel;
import net.morilib.dc.DcInterpreter;
import net.morilib.dc.DcModel;
import net.morilib.dc.DcParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BcParser {
    private DcParser<DcModel> dcparser;
    private DcModel dcmodel;
    private PrintStream output;

    public BcParser(InputStream ins, PrintStream ous) {
        this.output = ous;
        this.dcmodel = new DcDefaultModel(ins, ous);
        this.dcparser = new DcParser<DcModel>(DcInterpreter.getInstance(), this.dcmodel);
    }

    void _statementList(BcLexer lex, BcNamespace ns, int lv, int fv, boolean lp, PrintWriter w) throws IOException {
        do {
            this._statement(lex, ns, lv, fv, lp, true, w);
            if (lex.isEof()) continue;
            lex.eateos();
        } while (!lex.isEof() && !lex.eqchar('}'));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void _statement(BcLexer lex, BcNamespace ns, int lv, int fv, boolean lp, boolean pr, PrintWriter w) throws IOException {
        if (lex.isSymbol("define")) {
            this._define(lex, ns, 0, w);
            return;
        } else {
            BcStringLiteral s = lex.getString();
            if (s != null) {
                w.format("[%s]", s.toString());
                return;
            } else if (lex.isSymbol("print")) {
                this._printList(lex, ns, lv, w);
                return;
            } else if (lex.eqchar('{')) {
                this._statementList(lex, ns, lv, fv, lp, w);
                return;
            } else if (lex.isSymbol("if")) {
                this._if(lex, ns, lv, fv, lp, w);
                return;
            } else if (lex.isSymbol("while")) {
                this._while(lex, ns, lv, w);
                return;
            } else if (lex.isSymbol("for")) {
                this._for(lex, ns, lv, w);
                return;
            } else if (lex.isSymbol("break")) {
                if (!lp) {
                    throw new BcSyntaxException();
                }
                w.format("%dQ", fv + 2);
                return;
            } else if (lex.isSymbol("continue")) {
                if (!lp) {
                    throw new BcSyntaxException();
                }
                w.format("%dQ", fv + 1);
                return;
            } else if (lex.isSymbol("halt")) {
                w.print('\u505c');
                return;
            } else if (lex.isSymbol("return")) {
                BcExprParser p = new BcExprParser(lex);
                if (lex.eqchar('(')) {
                    p.parseExpression(ns, w);
                    lex.eatchar(')');
                } else if (!lex.isEof() && !lex.checkeos()) {
                    p.parseExpression(ns, w);
                } else {
                    w.print("0 ");
                }
                w.format("%dQ", lv + 1);
                return;
            } else if (lex.isSymbol("throw")) {
                s = lex.getString();
                if (s == null) throw new BcSyntaxException();
                w.format("[%s]\u8aa4", s.toString());
                return;
            } else if (lex.isSymbol("roundingmode")) {
                s = lex.getString();
                if (s != null) {
                    w.format("[%s]R", s.toString());
                    return;
                } else {
                    w.format("l%cp\u6368", Character.valueOf('\uff06'));
                }
                return;
            } else {
                if (lex.isSymbol("limits")) return;
                if (lex.isSymbol("quit")) {
                    throw new BcQuitException();
                }
                if (lex.checkeos()) return;
                BcExprParser p = new BcExprParser(lex);
                if (p.parseExpression(ns, w) && pr) {
                    w.print('p');
                }
                w.print('\u6368');
            }
        }
    }

    private void putz(String f, List<String> k, BcNamespace ns, PrintWriter w) {
        if (k != null) {
            int i = 0;
            while (i < k.size()) {
                char d = ns.getCharacter(k.get(i));
                w.format(f, Character.valueOf(d));
                ++i;
            }
        }
    }

    void _define(BcLexer lex, BcNamespace ns, int lv, PrintWriter w) throws IOException {
        char c;
        int i;
        List<String> k = null;
        String s = lex.eatSymbol();
        lex.eatchar('(');
        List<String> l = this._variableList(lex, ns, w);
        lex.eatchar(')');
        lex.skipnl();
        lex.eatchar('{');
        lex.skipnl();
        if (lex.isSymbol("auto")) {
            k = this._variableList(lex, ns, w);
            i = 0;
            while (i < k.size()) {
                ns.allocLocalCharacter(k.get(i));
                ++i;
            }
            lex.eqchar(';');
            lex.skipnl();
        }
        w.print('[');
        if (l.get(l.size() - 1).equals("...")) {
            c = ns.defineFunction(s, true, l.subList(0, l.size() - 2));
            l.remove(l.size() - 1);
            char a = ns.allocLocalCharacter(l.remove(l.size() - 1).toString());
            w.format("%d\u5909%c", l.size(), Character.valueOf(a));
            i = l.size() - 1;
            while (i >= 0) {
                w.format("S%c", Character.valueOf(ns.allocLocalCharacter(l.get(i))));
                --i;
            }
        } else {
            c = ns.defineFunction(s, false, l);
            w.print('\u6368');
            i = l.size() - 1;
            while (i >= 0) {
                w.format("S%c", Character.valueOf(ns.allocLocalCharacter(l.get(i))));
                --i;
            }
        }
        this.putz("0S%c", k, ns, w);
        w.print('[');
        this._statementList(lex, ns, 0, 0, false, w);
        w.print("]x");
        this.putz("L%c\u6368", k, ns, w);
        this.putz("L%c\u6368", l, ns, w);
        w.format("]s%c", Character.valueOf(c));
        ns.clearLocalCharacter();
    }

    List<String> _variableList(BcLexer lex, BcNamespace ns, PrintWriter w) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        lex.skipnl();
        if (lex.checkchar(')')) {
            return l;
        }
        do {
            lex.skipnl();
            l.add(lex.eatSymbol());
            if (lex.isSymbol("...")) {
                l.add("...");
                lex.skipnl();
                break;
            }
            lex.skipnl();
        } while (lex.eqchar(','));
        return l;
    }

    void _printList(BcLexer lex, BcNamespace ns, int lv, PrintWriter w) throws IOException {
        int n = 0;
        do {
            BcStringLiteral s;
            if ((s = lex.getString()) != null) {
                w.format("[%s]", s.toString());
            } else {
                BcExprParser p = new BcExprParser(lex);
                p.parseExpression(ns, w);
            }
            ++n;
        } while (lex.eqchar(','));
        w.format("%d\u5237", n);
    }

    void _if(BcLexer lex, BcNamespace ns, int lv, int fv, boolean lp, PrintWriter w) throws IOException {
        lex.setnl();
        lex.eatchar('(');
        BcExprParser p = new BcExprParser(lex);
        p.parseExpression(ns, w);
        lex.eatchar(')');
        lex.skipnl();
        w.print('[');
        this._statement(lex, ns, lv + 1, fv + 1, lp, true, w);
        w.print(']');
        lex.setnl();
        w.print('[');
        if (lex.isSymbol("else")) {
            lex.skipnl();
            this._statement(lex, ns, lv + 1, fv + 1, lp, true, w);
        }
        w.print("]\uff1f");
    }

    void _while(BcLexer lex, BcNamespace ns, int lv, PrintWriter w) throws IOException {
        StringWriter a = new StringWriter();
        PrintWriter b = new PrintWriter(a);
        lex.setnl();
        lex.eatchar('(');
        BcExprParser p = new BcExprParser(lex);
        p.parseExpression(ns, b);
        lex.eatchar(')');
        lex.skipnl();
        w.format("[%s[[", a.toString());
        char c = ns.pushLoop();
        this._statement(lex, ns, lv + 2, 0, true, true, w);
        w.format("]xl%c\u8d70][]\u5c90]s%cl%cx", Character.valueOf(c), Character.valueOf(c), Character.valueOf(c));
    }

    void _for(BcLexer lex, BcNamespace ns, int lv, PrintWriter w) throws IOException {
        BcExprParser p;
        StringWriter a = new StringWriter();
        StringWriter x = new StringWriter();
        PrintWriter b = new PrintWriter(a);
        PrintWriter y = new PrintWriter(x);
        lex.setnl();
        lex.eatchar('(');
        if (!lex.eqchar(';')) {
            p = new BcExprParser(lex);
            p.parseExpression(ns, w);
            w.print('\u6368');
            lex.eqchar(';');
        }
        if (!lex.eqchar(';')) {
            p = new BcExprParser(lex);
            p.parseExpression(ns, b);
            lex.eqchar(';');
        } else {
            b.print('1');
        }
        if (!lex.eqchar(')')) {
            p = new BcExprParser(lex);
            p.parseExpression(ns, y);
            y.print("\u6368");
            lex.eqchar(')');
        }
        lex.skipnl();
        w.format("[%s[[", a.toString());
        char c = ns.pushLoop();
        this._statement(lex, ns, lv + 2, 0, true, true, w);
        w.format("]x%sl%c\u8d70][]\u5c90]s%cl%cx", x.toString(), Character.valueOf(c), Character.valueOf(c), Character.valueOf(c));
        ns.popLoop();
    }

    public void parse(BcLexer lex, BcNamespace ns, PrintWriter w) throws IOException {
        this._statement(lex, ns, 0, 0, false, true, w);
    }

    public void run(Reader src, BcNamespace ns, int level) throws IOException {
        BcLexer lex = new BcLexer(src, level);
        do {
            PipedWriter p = new PipedWriter();
            PrintWriter w = new PrintWriter(p);
            PipedReader r = new PipedReader(p);
            while (lex.isEof()) {
                lex.restart();
            }
            this._statement(lex, ns, 0, 0, false, true, w);
            if (!lex.isEof()) {
                lex.eateos();
            }
            w.close();
            this.dcparser.parse(r);
            if (this.dcmodel.isEmpty()) continue;
            this.output.println(this.dcmodel.pop());
        } while (!lex.isEof());
    }
}

