/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.c.pre;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.c.pre.CpreMacros;
import net.morilib.c.pre.CpreSyntaxException;
import net.morilib.c.pre.CpreUtils;
import net.morilib.c.pre.RemoveCCommentReader;
import net.morilib.c.pre.directive.CpreDefine;
import net.morilib.c.pre.directive.CpreDirective;
import net.morilib.c.pre.directive.CpreElif;
import net.morilib.c.pre.directive.CpreElse;
import net.morilib.c.pre.directive.CpreEndif;
import net.morilib.c.pre.directive.CpreError;
import net.morilib.c.pre.directive.CpreIf;
import net.morilib.c.pre.directive.CpreIfState;
import net.morilib.c.pre.directive.CpreIfdef;
import net.morilib.c.pre.directive.CpreIfndef;
import net.morilib.c.pre.directive.CpreNull;
import net.morilib.c.pre.directive.CprePragma;
import net.morilib.c.pre.directive.CpreUndef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPreprocessorReader
extends Reader {
    static final Map<String, CpreDirective> DIRS;
    static final Pattern PI1;
    static final Pattern PI2;
    static final SimpleDateFormat DATEFMT;
    static final SimpleDateFormat TIMEFMT;
    static final String ERR001 = "#include requires <filename> or \"filename\"";
    private Stack<LineNumberReader> rd = new Stack();
    private Stack<CpreIfState> ifstat = new Stack();
    private Stack<String> fns = new Stack();
    private CpreMacros macros;
    private String line = null;
    private int ptr = 0;

    static {
        PI1 = Pattern.compile("#include *<(.+)>");
        PI2 = Pattern.compile("#include *\"(.+)\"");
        DATEFMT = new SimpleDateFormat("MMM dd yyyy", Locale.US);
        TIMEFMT = new SimpleDateFormat("HH:mm:ss", Locale.US);
        HashMap<String, CpreDirective> d = new HashMap<String, CpreDirective>();
        d.put("#", new CpreNull());
        d.put("#define", new CpreDefine());
        d.put("#elif", new CpreElif());
        d.put("#else", new CpreElse());
        d.put("#endif", new CpreEndif());
        d.put("#error", new CpreError());
        d.put("#if", new CpreIf());
        d.put("#ifdef", new CpreIfdef());
        d.put("#ifndef", new CpreIfndef());
        d.put("#pragma", new CprePragma());
        d.put("#undef", new CpreUndef());
        DIRS = Collections.unmodifiableMap(d);
    }

    public CPreprocessorReader(String fname, Date date, Reader in) {
        this.rd.push(new LineNumberReader(new RemoveCCommentReader(in)));
        this.fns.push(fname != null ? fname : "<no name>");
        this.ifstat.add(CpreIfState.TOP);
        this.macros = new CpreMacros();
        this.macros.define("__STDC__", "1");
        this.macros.define("__FILE__", fname);
        char[] df = DATEFMT.format(date).toCharArray();
        if (df[4] == '0') {
            df[4] = 32;
        }
        this.macros.define("__DATE__", new String(df));
        this.macros.define("__TIME__", TIMEFMT.format(date));
        this.macros.define("__STDC_VERSION__", "199912");
    }

    public CPreprocessorReader(String fname, Reader in) {
        this(fname, new Date(), in);
    }

    static String substitute(Reader rd, CpreMacros macros, Set<String> done, int lineno, boolean sh) throws IOException {
        ArrayList<String> l0 = null;
        StringBuffer b1 = null;
        StringBuffer b2 = null;
        String nm = null;
        S0 st = S0.INI;
        StringBuffer b0 = new StringBuffer();
        while (true) {
            int c = rd.read();
            switch (st) {
                case INI: {
                    if (CpreUtils.isCMacroIdentifierStart(c)) {
                        b1 = new StringBuffer().appendCodePoint(c);
                        st = S0.EX1;
                        break;
                    }
                    if (c == 35) {
                        st = S0.SH1;
                        break;
                    }
                    if (c == 34) {
                        b0.append('\"');
                        st = S0.DQ1;
                        break;
                    }
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    break;
                }
                case SH1: {
                    if (CpreUtils.isCMacroIdentifierStart(c)) {
                        b1 = new StringBuffer().appendCodePoint(c);
                        st = S0.EX2;
                        break;
                    }
                    if (c == 35) {
                        b0.append('#').append('#');
                        st = S0.INI;
                        break;
                    }
                    if (c < 0) {
                        return b0.append('#').toString();
                    }
                    b0.append('#').appendCodePoint(c);
                    st = S0.INI;
                    break;
                }
                case EX1: {
                    String s;
                    if (CpreUtils.isCMacroIdentifierPart(c)) {
                        b1.append((char)c);
                        break;
                    }
                    if (c == 40) {
                        nm = b1.toString();
                        l0 = new ArrayList<String>();
                        b2 = new StringBuffer().append('(');
                        b1 = new StringBuffer();
                        st = S0.AR1;
                        break;
                    }
                    if (!sh || done.contains(b1.toString().trim())) {
                        b0.append(b1.toString());
                    } else if (b1.toString().trim().equals("__LINE__")) {
                        b0.append(lineno);
                    } else {
                        done.add(b1.toString().trim());
                        s = macros.substitute(b1.toString().trim());
                        b0.append(s != null ? s : b1);
                    }
                    if (c < 0) {
                        return b0.toString();
                    }
                    if (c == 35) {
                        st = S0.SH1;
                        break;
                    }
                    b0.appendCodePoint(c);
                    st = S0.INI;
                    break;
                }
                case EX2: {
                    String s;
                    if (CpreUtils.isCMacroIdentifierPart(c)) {
                        b1.append((char)c);
                        break;
                    }
                    if (c == 40) {
                        nm = b1.toString();
                        l0 = new ArrayList();
                        b2 = new StringBuffer().append('(');
                        b1 = new StringBuffer();
                        st = S0.AR2;
                        break;
                    }
                    if (!sh || done.contains(b1.toString().trim())) {
                        b0.append(b1.toString());
                    } else {
                        done.add(b1.toString().trim());
                        b0.append('\"');
                        s = macros.substitute(b1.toString().trim());
                        b0.append(s != null ? s : b1);
                    }
                    if (c < 0) {
                        return b0.append('\"').toString();
                    }
                    if (c == 35) {
                        st = S0.SH1;
                        break;
                    }
                    b0.append('\"').appendCodePoint(c);
                    st = S0.INI;
                    break;
                }
                case AR1: {
                    String s1;
                    if (c == 41) {
                        if (done.contains(nm.trim()) || nm.equals("defined")) {
                            b0.append(nm).append(b2);
                            b0.append(b1).append(')');
                        } else {
                            done.add(nm.trim());
                            l0.add(b1.toString().trim());
                            s1 = macros.substitute(nm.trim(), lineno, l0);
                            if (!sh || s1 != null) {
                                b0.append(s1);
                            } else {
                                b2.append(b1).append(')');
                                b0.append(nm);
                                b0.append(CPreprocessorReader.substitute(new StringReader(b2.toString()), macros, new HashSet<String>(done), lineno, true));
                            }
                            b1 = new StringBuffer();
                        }
                        st = S0.INI;
                        break;
                    }
                    if (c == 44) {
                        l0.add(b1.toString().trim());
                        b2.append(CPreprocessorReader.substitute(new StringReader(b1.toString()), macros, new HashSet<String>(done), lineno, true));
                        b2.appendCodePoint(c);
                        b1 = new StringBuffer();
                        break;
                    }
                    if (c < 0) {
                        return b0.append(b2).toString();
                    }
                    b1.appendCodePoint(c);
                    break;
                }
                case AR2: {
                    String s1;
                    if (c == 41) {
                        if (done.contains(nm.trim()) || nm.equals("defined")) {
                            b0.append(nm).append(b2);
                            b0.append(b1).append(')');
                        } else {
                            done.add(nm.trim());
                            l0.add(b1.toString().trim());
                            b0.append('\"');
                            s1 = macros.substitute(nm.trim(), lineno, l0);
                            if (!sh || s1 != null) {
                                b0.append(s1);
                            } else {
                                b2.append(b1).append(')');
                                b0.append(nm);
                                b0.append(CPreprocessorReader.substitute(new StringReader(b2.toString()), macros, new HashSet<String>(done), lineno, true));
                            }
                            b0.append('\"');
                            b1 = new StringBuffer();
                        }
                        st = S0.INI;
                        break;
                    }
                    if (c == 44) {
                        l0.add(b1.toString().trim());
                        b2.append(CPreprocessorReader.substitute(new StringReader(b1.toString()), macros, new HashSet<String>(done), lineno, true));
                        b2.appendCodePoint(c);
                        b1 = new StringBuffer();
                        break;
                    }
                    if (c < 0) {
                        return b0.append(b2).toString();
                    }
                    b1.appendCodePoint(c);
                    break;
                }
                case DQ1: {
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    if (c == 34) {
                        st = S0.INI;
                        break;
                    }
                    if (c != 92) break;
                    st = S0.DQ2;
                    break;
                }
                case DQ2: {
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    st = S0.DQ1;
                }
            }
        }
    }

    static String substitutep2(Reader rd) throws IOException {
        StringBuffer b1 = null;
        S1 st = S1.INI;
        StringBuffer b0 = new StringBuffer();
        while (true) {
            int c = rd.read();
            switch (st) {
                case INI: {
                    if (c == 35) {
                        st = S1.SH1;
                        break;
                    }
                    if (c == 34) {
                        b0.appendCodePoint(c);
                        st = S1.DQ1;
                        break;
                    }
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    break;
                }
                case SH1: {
                    if (c == 35) {
                        b1 = new StringBuffer();
                        st = S1.SH2;
                        break;
                    }
                    if (c == 34) {
                        b0.append('#').append('\"');
                        st = S1.DQ1;
                        break;
                    }
                    if (c < 0) {
                        return b0.append('#').toString();
                    }
                    b0.append('#').appendCodePoint(c);
                    st = S1.INI;
                    break;
                }
                case SH2: {
                    char d;
                    if (c == 32 || c == 9) {
                        b1.append((char)c);
                        break;
                    }
                    if (c < 0) {
                        b0.append('#').append('#').append(b1);
                        return b0.toString();
                    }
                    int i = b0.length() - 1;
                    while (i >= 0) {
                        d = b0.charAt(i);
                        if (d != ' ' && d != '\t') break;
                        b0.deleteCharAt(i);
                        --i;
                    }
                    b0.appendCodePoint(c);
                    st = S1.INI;
                    break;
                }
                case DQ1: {
                    if (c == 34) {
                        st = S1.DQ2;
                    } else if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    break;
                }
                case DQ2: {
                    char d;
                    int i;
                    if (c == 32 || c == 9) {
                        b0.append((char)c);
                        break;
                    }
                    if (c == 34) {
                        i = b0.length() - 1;
                        while (i >= 0) {
                            d = b0.charAt(i);
                            if (d != ' ' && d != '\t') break;
                            b0.deleteCharAt(i);
                            --i;
                        }
                        b0.deleteCharAt(b0.length() - 1);
                        st = S1.DQ1;
                        break;
                    }
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    st = S1.INI;
                }
            }
        }
    }

    public static String substitute(String s, int lineno, CpreMacros macros) {
        HashSet<String> done = new HashSet<String>();
        String t = null;
        try {
            while (!s.equals(t)) {
                t = s;
                StringReader r = new StringReader(t);
                s = CPreprocessorReader.substitute(r, macros, done, lineno, true);
                r.close();
                r = new StringReader(s);
                s = CPreprocessorReader.substitutep2(r);
                r.close();
            }
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    String readLine0() throws IOException {
        if (this.rd.size() != 0) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            if (this.rd.size() > 1) {
                this.rd.pop().close();
                continue;
            }
            this.rd.pop();
            return null;
lbl9:
            // 2 sources

            ** while ((s = this.rd.peek().readLine()) == null)
        }
lbl10:
        // 1 sources

        if (!s.endsWith("\\")) {
            return s;
        }
        t = this.readLine0();
        if (t == null) {
            return s.substring(0, s.length() - 1);
        }
        return String.valueOf(s.substring(0, s.length() - 1)) + t;
    }

    String[] getincpath() {
        String ps = System.getProperty("path.separator");
        String s0 = System.getenv("INCLUDE");
        s0 = s0 != null ? s0 : "";
        String[] r = s0.split(ps);
        return r;
    }

    void openinc1(File fn) throws IOException {
        this.rd.push(new LineNumberReader(new RemoveCCommentReader(new InputStreamReader(new FileInputStream(fn)))));
        this.fns.push(fn.toString());
    }

    boolean openinc(String fn) throws IOException {
        String[] pt;
        String[] stringArray = pt = this.getincpath();
        int n = pt.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            File f = new File(d, fn);
            if (f.isFile()) {
                this.openinc1(f);
                return true;
            }
            ++n2;
        }
        return false;
    }

    String[] split2(String s) {
        String[] r = new String[2];
        r[1] = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t') {
                r[0] = s.substring(0, i);
                int j = i;
                while (j < s.length()) {
                    if (s.charAt(j) != ' ' && s.charAt(j) != '\t') {
                        r[1] = s.substring(j);
                        return r;
                    }
                    ++j;
                }
                return r;
            }
            ++i;
        }
        r[0] = s;
        return r;
    }

    /*
     * Enabled aggressive block sorting
     */
    void processInclude(String s, int nm) throws IOException {
        String ps = System.getProperty("path.separator");
        Matcher m = PI1.matcher(s);
        if (m.matches()) {
            String fn = m.group(1);
            if (ps.equals(":")) {
                File f = new File("/usr/include", fn);
                if (!f.isFile()) throw new CpreSyntaxException(this.getLineNumber(), String.valueOf(fn) + " not found");
                this.openinc1(f);
                return;
            }
            if (this.openinc(m.group(1))) return;
            throw new CpreSyntaxException(this.getLineNumber(), ERR001);
        }
        m = PI2.matcher(s);
        if (m.matches()) {
            String fn = m.group(1);
            File f = new File(fn);
            if (f.isFile()) {
                this.openinc1(f);
                return;
            }
            if (this.openinc(m.group(1))) return;
            throw new CpreSyntaxException(this.getLineNumber(), ERR001);
        }
        if (nm > 0) {
            throw new CpreSyntaxException(this.getLineNumber(), ERR001);
        }
        String t = CPreprocessorReader.substitute(s, this.rd.peek().getLineNumber(), this.macros);
        this.processInclude(t, nm + 1);
    }

    String processLine() throws IOException {
        String s = this.readLine0();
        if (s == null) {
            return null;
        }
        String[] s2 = this.split2(s);
        int ln = this.rd.peek().getLineNumber();
        if (s.startsWith("#include")) {
            this.processInclude(s, 0);
            return this.processLine();
        }
        CpreDirective d = DIRS.get(s2[0]);
        if (d != null) {
            CpreIfState ifs = d.execute(this.macros, s2[1], ln, this.ifstat.peek());
            switch (ifs) {
                case BEGIN: {
                    this.ifstat.push(CpreIfState.PROCESSING);
                    return "";
                }
                case READY: {
                    this.ifstat.push(CpreIfState.UNPROCESSED);
                    return "";
                }
                case UNPROCESSED: 
                case PROCESSING: 
                case PROCESSED: 
                case PROCESSING_ELSE: 
                case DONE: {
                    this.ifstat.pop();
                    this.ifstat.push(ifs);
                    return "";
                }
                case RETURN: {
                    if (this.ifstat.size() <= 1) {
                        throw new CpreSyntaxException(this.getLineNumber(), "unbalanced #endif");
                    }
                    this.ifstat.pop();
                    return "";
                }
                case STAY: {
                    return "";
                }
                case TOP: {
                    throw new RuntimeException();
                }
            }
        }
        if (!s.startsWith("#")) {
            s = this.ifstat.peek().isProcessing() ? CPreprocessorReader.substitute(s, ln, this.macros) : "";
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public String readLine() throws IOException {
        block2: {
            r = this.line;
            this.ptr = 0;
            if (this.line == null) ** GOTO lbl7
            this.line = null;
            break block2;
lbl-1000:
            // 1 sources

            {
                r = this.processLine();
lbl7:
                // 2 sources

                ** while (r == null && this.rd.size() > 0)
            }
        }
        if (r == null && this.ifstat.size() > 1) {
            throw new CpreSyntaxException(-1, "unbalanced #if/#ifdef");
        }
        return r;
    }

    public int getLineNumber() {
        return this.rd.peek().getLineNumber();
    }

    @Override
    public int read() throws IOException {
        if (this.line == null) {
            this.ptr = 0;
        }
        while (this.line == null && this.rd.size() > 0) {
            this.line = this.processLine();
        }
        if (this.line == null) {
            return -1;
        }
        if (this.ptr < this.line.length()) {
            return this.line.charAt(this.ptr++);
        }
        this.line = null;
        return 10;
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c < 0) {
                return i == off ? -1 : i - off;
            }
            b[i] = (char)c;
            ++i;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long i = 0L;
        while (i < n) {
            if (!this.rd.peek().ready() || this.read() < 0) {
                return i;
            }
            ++i;
        }
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public void close() throws IOException {
        while (!this.rd.isEmpty()) {
            this.rd.pop().close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum S0 {
        INI,
        SH1,
        EX1,
        EX2,
        AR1,
        AR2,
        DQ1,
        DQ2;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum S1 {
        INI,
        SH1,
        SH2,
        DQ1,
        DQ2;

    }
}

