/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.morilib.dc.LookaheadReader;

public class DcReader
extends Reader {
    private List<LookaheadReader> readers = new ArrayList<LookaheadReader>();

    public DcReader(LookaheadReader rd) {
        this.readers.add(rd);
    }

    public LookaheadReader peek() {
        return this.readers.get(this.readers.size() - 1);
    }

    public void pushOrSetStringAsReader(String s) throws IOException {
        LookaheadReader rd = new LookaheadReader(new StringReader(s), 1);
        if (this.peek().isEof()) {
            this.readers.set(this.readers.size() - 1, rd);
        } else {
            this.readers.add(rd);
        }
    }

    public void pushStringAsReader(String s) throws IOException {
        LookaheadReader rd = new LookaheadReader(new StringReader(s), 1);
        this.readers.add(rd);
    }

    public int getLevel() {
        return this.readers.size() - 1;
    }

    public void pop() {
        this.readers.remove(this.readers.size() - 1);
    }

    public void close() throws IOException {
        if (this.readers != null) {
            for (Reader reader : this.readers) {
                reader.close();
            }
            this.readers = null;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int a = 0;
        while (a < len) {
            if (this.readers.size() == 0) {
                return a > 0 ? a : -1;
            }
            int l = this.peek().read(cbuf, off + a, len - a);
            if (l < 0) {
                this.peek().close();
                this.readers.remove(this.readers.size() - 1);
                continue;
            }
            a += l;
        }
        return len;
    }
}

