/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import net.morilib.dc.number.Rational;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PiMachinSeries
implements Iterator<Rational> {
    public static final Iterable<Rational> FACTORY = new Iterable<Rational>(){

        @Override
        public Iterator<Rational> iterator() {
            return new PiMachinSeries();
        }
    };
    private Rational FIVETOTHE2 = Rational.valueOf(25);
    private Rational _239TOTHE2 = Rational.valueOf(57121);
    private Rational FOUR = Rational.valueOf(4);
    private Rational _16 = Rational.valueOf(16);
    private int m5 = 1;
    private int m239 = 1;
    private Rational over5 = Rational.valueOf(5).invert();
    private Rational over239 = Rational.valueOf(239).invert();
    private Rational sumover5 = this.over5;
    private Rational sumover239 = this.over239;

    public static BigDecimal getPi(int scale, RoundingMode mode) {
        PiMachinSeries p = new PiMachinSeries();
        BigDecimal a = BigDecimal.ZERO;
        BigDecimal b = BigDecimal.ONE;
        while (!a.equals(b)) {
            a = b;
            b = Rational.toBigDecimal(p.next(), scale, mode);
        }
        return b;
    }

    private void nextover5() {
        this.over5 = this.over5.divide(this.FIVETOTHE2).negate();
        this.sumover5 = this.sumover5.add(this.over5.divide(Rational.valueOf(2 * this.m5++ + 1)));
    }

    private void nextover239() {
        this.over239 = this.over239.divide(this._239TOTHE2).negate();
        this.sumover239 = this.sumover239.add(this.over239.divide(Rational.valueOf(2 * this.m239++ + 1)));
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Rational next() {
        Rational r = this.sumover5.multiply(this._16).subtract(this.sumover239.multiply(this.FOUR));
        this.nextover5();
        this.nextover239();
        return r;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

