/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShUniq
implements ShProcess {
    private static final Pattern FNUM = Pattern.compile("-[0-9]+");
    private static final Pattern SNUM = Pattern.compile("\\+[0-9]+");
    private static final Pattern FSEP = Pattern.compile("[ \t]+");
    private static final int UNIQUE = 1;
    private static final int REPEATED = 2;
    private static final int R_MASK = 3;
    private static final int COUNT = 4;
    private static final int SKIP_FIELD = 8;
    private static final int SKIP_CHARS = 16;
    private static final int CHECK_CHARS = 32;

    private int getskip(String s, int i) {
        if (i < s.length()) {
            try {
                int k = Integer.parseInt(s.substring(i));
                return k < 0 ? Integer.MAX_VALUE : k;
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    private int getskip2(String s, int i) {
        if (i < s.length()) {
            try {
                return Integer.parseInt(s.substring(i));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private int analyzeopt(String s, S1 f) {
        int i = 1;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case 'u': {
                    f.flags = f.flags & 0xFFFFFFFC | 1;
                    break;
                }
                case 'd': {
                    f.flags = f.flags & 0xFFFFFFFC | 2;
                    break;
                }
                case 'c': {
                    f.flags |= 4;
                    break;
                }
                case 'f': {
                    f.flags |= 8;
                    f.skip = this.getskip(s, i + 1);
                    return -1;
                }
                case 's': {
                    f.flags |= 0x10;
                    f.skip = this.getskip(s, i + 1);
                    return -1;
                }
                case 'w': {
                    f.flags |= 0x20;
                    f.endc = this.getskip(s, i + 1);
                    return -1;
                }
                default: {
                    return s.charAt(i);
                }
            }
            ++i;
        }
        return -1;
    }

    private String exts(S1 f, String s) {
        switch (f.flags & 0x18) {
            case 0: {
                return (long)f.endc < (long)s.length() ? s.substring(0, f.endc) : s;
            }
            case 16: {
                if (f.skip > s.length()) {
                    return "";
                }
                return (long)f.endc + (long)f.skip < (long)s.length() ? s.substring(f.skip, f.skip + f.endc) : s.substring(f.skip);
            }
            case 8: 
            case 24: {
                int k;
                Matcher m = FSEP.matcher(s);
                int i = 0;
                while (i < f.skip && m.find()) {
                    ++i;
                }
                if (i == f.skip && (k = m.end()) < s.length()) {
                    return (long)f.endc + (long)k < (long)s.length() ? s.substring(k, k + f.endc) : s.substring(k);
                }
                return "";
            }
        }
        throw new RuntimeException();
    }

    private void prc(S1 fl, PrintStream out, int c) {
        if ((fl.flags & 4) != 0) {
            out.format("%7d ", c);
        }
    }

    private void uniq(InputStream ins, PrintStream out, String name, S1 fl, Charset cset) throws IOException {
        String t;
        BufferedReader rd = new BufferedReader(new InputStreamReader(ins, cset));
        String p = null;
        String q = null;
        int c = 1;
        while ((t = rd.readLine()) != null) {
            String s = this.exts(fl, t);
            if (p == null) {
                p = t;
                q = s;
                continue;
            }
            if (s.equals(q)) {
                ++c;
                continue;
            }
            if ((fl.flags & 1) != 0 && c == 1) {
                this.prc(fl, out, c);
                out.println(p);
            } else if ((fl.flags & 2) != 0 && c > 1) {
                this.prc(fl, out, c);
                out.println(p);
            }
            p = t;
            q = s;
            c = 1;
        }
        if ((fl.flags & 1) != 0 && c == 1) {
            this.prc(fl, out, c);
            out.println(p);
        } else if ((fl.flags & 2) != 0 && c > 1) {
            this.prc(fl, out, c);
            out.println(p);
        }
    }

    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        InputStream ins = null;
        PrintStream ous = null;
        S1 f = new S1();
        int k = 1;
        while (k < args.length) {
            if (f.skip < 0) {
                f.skip = this.getskip(args[k], 0);
            } else if (f.endc < 0) {
                f.endc = this.getskip(args[k], 0);
            } else if (FNUM.matcher(args[k]).matches()) {
                f.flags |= 8;
                f.skip = this.getskip(args[k], 1);
            } else if (SNUM.matcher(args[k]).matches()) {
                f.flags |= 0x10;
                f.skip = this.getskip(args[k], 1);
            } else if (args[k].startsWith("--skip-fields=") && args[k].length() > 8) {
                f.flags |= 8;
                f.skip = this.getskip2(args[k], 14);
                if (f.skip < 0) {
                    err.println("uniq: invalid number");
                    return 2;
                }
            } else if (args[k].startsWith("--skip-chars=") && args[k].length() > 8) {
                f.flags |= 0x10;
                f.skip = this.getskip2(args[k], 13);
                if (f.skip < 0) {
                    err.println("uniq: invalid number");
                    return 2;
                }
            } else if (args[k].startsWith("--check-chars=") && args[k].length() > 13) {
                f.flags |= 0x20;
                f.endc = this.getskip2(args[k], 14);
                if (f.endc < 0) {
                    err.println("uniq: invalid number");
                    return 2;
                }
            } else if (args[k].equals("--unique")) {
                f.flags = f.flags & 0xFFFFFFFC | 1;
            } else if (args[k].equals("--repeated")) {
                f.flags = f.flags & 0xFFFFFFFC | 2;
            } else if (args[k].equals("--count")) {
                f.flags |= 4;
            } else {
                if (args[k].equals("--")) {
                    ++k;
                    break;
                }
                if (args[k].equals("-") || !args[k].startsWith("-")) break;
                int z = this.analyzeopt(args[k], f);
                if (z >= 0) {
                    err.println("uniq: invalid option: " + (char)z);
                    return 2;
                }
            }
            ++k;
        }
        if (f.skip < 0 || f.endc < 0) {
            err.println("uniq: missing number");
            return 2;
        }
        if (k >= args.length) {
            this.uniq(in, out, "standard input", f, env.getCharset());
        } else {
            try {
                if (!args[k].equals("-")) {
                    ins = fs.getFile(args[k]).getInputStream();
                    if (ins == null) {
                        err.print("uniq: ");
                        err.print(args[k]);
                        err.println(": file not found");
                        return 2;
                    }
                } else {
                    ins = in;
                }
                ous = k - args.length > 1 && !args[k + 1].equals("-") ? fs.getFile(args[k + 1]).getPrintStream(false) : out;
                this.uniq(ins, ous, args[k], f, env.getCharset());
            }
            finally {
                if (ins != in && ins != null) {
                    ins.close();
                }
                if (ous != out && ous != null) {
                    ous.close();
                }
            }
        }
        return 0;
    }

    private static class S1 {
        int skip = Integer.MAX_VALUE;
        int endc = Integer.MAX_VALUE;
        int flags = 3;

        private S1() {
        }
    }
}

