/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.file.ShOSProcess;
import net.morilib.sh.file.ShRealFile;
import net.morilib.sh.misc.FileTypeUtils;

public class ShWindowsRealFile
extends ShRealFile {
    public ShWindowsRealFile(ShFileSystem fs, String virtualpath, File file) {
        super(fs, virtualpath, file);
    }

    public ShProcess getProcess(String ... args) {
        if (this.file.getName().endsWith(".exe") && FileTypeUtils.guessWindowsExecutable(this.file)) {
            if (this.filesystem.getSecurityPolicy().denyExecuteOSCommand()) {
                return null;
            }
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(args));
            l.set(0, this.filesystem.getFile((String)l.get(0)).toString());
            ProcessBuilder p = new ProcessBuilder(l);
            return new ShOSProcess(p);
        }
        String[] a = FileTypeUtils.parseShebang(this.file);
        if (a != null && a[1].equals("jsh")) {
            return null;
        }
        if (a != null && a[0] != null && a[1] != null) {
            return null;
        }
        return null;
    }

    public boolean isExecutable() {
        if (this.file.isDirectory()) {
            return true;
        }
        if (this.file.isFile()) {
            return FileTypeUtils.parseShebang(this.file) != null;
        }
        return false;
    }
}

