/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.glob;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.morilib.unix.charset.IntInterval;
import net.morilib.unix.charset.IntRange;
import net.morilib.unix.charset.UnixCharSetException;
import net.morilib.unix.charset.UnixCharSets;
import net.morilib.unix.glob.WildcardSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Wildcard {
    private IntRange[] chars;
    private List<Boolean> repeat;

    private Wildcard(IntRange[] chars, List<Boolean> repeat) {
        this.chars = chars;
        this.repeat = repeat;
    }

    public boolean matches(CharSequence cs) {
        HashSet<Integer> ss = new HashSet<Integer>();
        HashSet<Integer> ad = new HashSet<Integer>();
        ss.add(0);
        int p = 0;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.chars[s].contains(c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            ++p;
        }
        return ss.contains(this.chars.length - 1);
    }

    public int lookingAtLongest(CharSequence cs, int start) {
        TreeSet<Integer> ss = new TreeSet<Integer>();
        TreeSet<Integer> ad = new TreeSet<Integer>();
        ss.add(0);
        int r = ss.contains(this.chars.length - 1) ? start : -1;
        int p = start;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.chars[s].contains(c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            if (ss.contains(this.chars.length - 1)) {
                r = p + 1;
            }
            ++p;
        }
        return r;
    }

    public int lookingAtShortest(CharSequence cs, int start) {
        TreeSet<Integer> ss = new TreeSet<Integer>();
        TreeSet<Integer> ad = new TreeSet<Integer>();
        ss.add(0);
        int p = start;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.chars[s].contains(c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            if (ss.contains(this.chars.length - 1)) {
                return p + 1;
            }
            ++p;
        }
        return -1;
    }

    int[] _findLongest(CharSequence cs, int s, int[] r) {
        int k = s;
        while (k <= cs.length()) {
            int l = this.lookingAtLongest(cs, k);
            if (l >= 0) {
                r[0] = k;
                r[1] = l;
                return r;
            }
            ++k;
        }
        return null;
    }

    int[] _findShortest(CharSequence cs, int s, int[] r) {
        int k = s;
        while (k <= cs.length()) {
            int l = this.lookingAtShortest(cs, k);
            if (l >= 0) {
                r[0] = k;
                r[1] = l;
                return r;
            }
            ++k;
        }
        return null;
    }

    public int lastLookingAtLongest(CharSequence s) {
        int[] a = new int[2];
        if (this._findLongest(s, 0, a) != null && a[1] == s.length()) {
            return a[0];
        }
        return -1;
    }

    public int lastLookingAtShortest(CharSequence s) {
        int[] a = new int[2];
        int i = s.length();
        while (i >= 0) {
            if (this._findLongest(s, i, a) != null && a[1] == s.length()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static Wildcard compile(CharSequence pt) {
        ArrayList<IntRange> rl = new ArrayList<IntRange>();
        ArrayList<Boolean> rp = new ArrayList<Boolean>();
        S1 stat = S1.INIT;
        boolean b = true;
        int p = 0;
        while (p < pt.length()) {
            char c = pt.charAt(p);
            block1 : switch (stat) {
                case INIT: {
                    switch (c) {
                        case '*': {
                            if (b) {
                                rp.add(true);
                            }
                            b = false;
                            break block1;
                        }
                        case '?': {
                            rl.add(UnixCharSets.ALL_CHAR);
                            if (b) {
                                rp.add(false);
                            }
                            b = true;
                            break block1;
                        }
                        case '[': {
                            int z = p + 1;
                            while (true) {
                                if (z >= pt.length()) {
                                    throw new WildcardSyntaxException();
                                }
                                if (pt.charAt(z) == ']') break;
                                ++z;
                            }
                            try {
                                rl.add(UnixCharSets.parse(pt.subSequence(p + 1, z)));
                            }
                            catch (UnixCharSetException e) {
                                throw new WildcardSyntaxException(e);
                            }
                            if (b) {
                                rp.add(false);
                            }
                            b = true;
                            p = z;
                            break block1;
                        }
                        case '\'': {
                            stat = S1.SQUT;
                            break block1;
                        }
                        case '\"': {
                            stat = S1.DQUT;
                            break block1;
                        }
                        case '\\': {
                            stat = S1.ESC1;
                            break block1;
                        }
                    }
                    rl.add(new IntInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case ESC1: {
                    stat = S1.INIT;
                    rl.add(new IntInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case SQUT: {
                    if (c == '\'') {
                        stat = S1.INIT;
                        break;
                    }
                    rl.add(new IntInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case DQUT: {
                    if (c == '\"') {
                        stat = S1.INIT;
                        break;
                    }
                    if (c == '\\') {
                        stat = S1.ESC2;
                        break;
                    }
                    rl.add(new IntInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case ESC2: {
                    stat = S1.DQUT;
                    rl.add(new IntInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                }
            }
            ++p;
        }
        if (b) {
            rp.add(false);
        }
        rl.add(IntRange.O);
        return new Wildcard(rl.toArray(new IntRange[0]), rp);
    }

    public static boolean matches(CharSequence pt, CharSequence cs) {
        return Wildcard.compile(pt).matches(cs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum S1 {
        INIT,
        ESC1,
        SQUT,
        DQUT,
        ESC2;

    }
}

