/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import java.util.List;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数s.rindexの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class SRindex extends AwkFunction {

	/**
	 * 
	 */
	public SRindex() {
		super("rindex", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		String s, t;
		int x;

		if(args.size() < 2) {
			return AwkInteger.ONE;
		} else {
			s = args.get(0).toString(ns);
			t = args.get(1).toString(ns);
			x = s.lastIndexOf(t);
			return AwkInteger.valueOf(x < 0 ? 0 : x + 1);
		}
	}

}
