/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.util.HashSet;
import java.util.Set;

import net.morilib.sh.misc.ShUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/01
 */
public final class ShProcessNumber {

	private static final double MU = 0.072;
	private static final double SD = 0.0072;

	private static Set<Integer> nums = new HashSet<Integer>();

	/**
	 * 
	 * @return
	 */
	public synchronized static int getNumber() {
		int v;

		while(nums.contains(
				v = ShUtils.normalRandomUnsignedShort(MU, SD)));
		nums.add(v);
		return v;
	}

	/**
	 * 
	 * @param n
	 */
	public synchronized static void releaseNumber(int n) {
		nums.remove(n);
	}

}
