/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShSet implements ShProcess {

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		for(int i = 1; i < args.length; i++) {
			if(args[i].equals("-C")) {
				env.set("noclobber");
			} else if(args[i].equals("+C")) {
				env.reset("noclobber");
			} else if(args[i].equals("-f")) {
				env.set("noglob");
			} else if(args[i].equals("+f")) {
				env.reset("noglob");
			} else if(args[i].equals("-n")) {
				env.set("noexec");
			} else if(args[i].equals("+n")) {
				env.reset("noexec");
			} else if(args[i].equals("-u")) {
				env.set("nounset");
			} else if(args[i].equals("+u")) {
				env.reset("nounset");
			} else if(args[i].equals("-v")) {
				env.set("verbose");
			} else if(args[i].equals("+v")) {
				env.reset("verbose");
			} else if(args[i].equals("-x")) {
				env.set("xtrace");
			} else if(args[i].equals("+x")) {
				env.reset("xtrace");
			} else if(args[i].equals("-o") && i < args.length - 1) {
				env.set(args[++i]);
			} else if(args[i].equals("+o") && i < args.length - 1) {
				env.reset(args[++i]);
			}
		}
		return 0;
	}

}
