/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

import java.util.regex.Pattern;

/**
 * 正規表現パターンのトークンです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03/09
 */
public class AwkRegexToken extends AwkToken {

	//
	private Pattern regex;

	/**
	 * トークンを生成します。
	 * 
	 * @param re 正規表現パターン
	 */
	public AwkRegexToken(Pattern re) {
		super(re.pattern());
		regex = re;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return desc.hashCode();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if(o instanceof AwkRegexToken) {
			return desc.equals(((AwkRegexToken)o).desc);
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.parser.AwkToken#getRegex()
	 */
	public Pattern getRegex() {
		return regex;
	}

}
