/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;

import net.morilib.awk.AwkSQLException;
import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkSQLConnection extends AwkUnaryArgs
implements AwkSQLCloseable {

	//
	private static final Pattern PS = Pattern.compile(
			"[ \t]*SELECT", Pattern.CASE_INSENSITIVE);

	//
	private Connection connect;

	/**
	 * 
	 * @param con
	 */
	public AwkSQLConnection(Connection con) {
		super("connection");
		connect = con;
	}

	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		try {
			if(PS.matcher(a1.toString()).lookingAt()) {
				return new AwkPreparedStatementQueryFunction(
						connect.prepareStatement(a1.toString()));
			} else {
				return new AwkPreparedStatementUpdateFunction(
						connect.prepareStatement(a1.toString()));
			}
		} catch(SQLException e) {
			throw new AwkSQLException(e);
		}
	}

	public void closeSQL() throws SQLException {
		connect.close();
	}

}
