/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShSleep implements ShProcess {

	private static final Pattern FMT =
		Pattern.compile("([0-9]+)([smhd]?)");

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		Matcher m;
		long t;

		if(args.length < 2 || !(m = FMT.matcher(args[1])).matches()) {
			err.println("sleep: illegal argument");
			return 2;
		} else {
			t = Long.parseLong(m.group(1));
			if(m.group(2).equals("m")) {
				t *= 60l;
			} else if(m.group(2).equals("h")) {
				t *= 3600l;
			} else if(m.group(2).equals("d")) {
				t *= 3600l * 24l;;
			}

			try {
				Thread.sleep(t * 1000l);
			} catch (InterruptedException e) {
				// ignore
			}
			return 0;
		}
	}

}
