/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.DistributionUtils;
import net.morilib.awk.stat.dist.AbstractContinuousDistribution;
import net.morilib.awk.stat.special.Erf;

public class NormalDistribution
extends AbstractContinuousDistribution {
    private double mean;
    private double variance;

    public NormalDistribution(double mean, double variance) {
        if (variance <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.mean = mean;
        this.variance = variance;
    }

    public double expectedValue() {
        return this.mean;
    }

    public double variance() {
        return this.variance;
    }

    public double mode() {
        return this.mean;
    }

    public double skewness() {
        return 0.0;
    }

    public double kurtosis() {
        return 0.0;
    }

    public double f(double x) {
        double k = -((x - this.mean) * (x - this.mean) / 2.0 / this.variance);
        double a = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        return a * Math.exp(k);
    }

    public boolean isInSupport(double n) {
        return true;
    }

    public double cdf(double x) {
        return DistributionUtils.trimCdf(0.5 * (1.0 + Erf.erf((x - this.mean) / Math.sqrt(2.0 * this.variance))), 1.0E-13);
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double supportInfimum() {
        return Double.NEGATIVE_INFINITY;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.mean));
        r = 37 * (r + (int)Double.doubleToLongBits(this.variance));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof NormalDistribution) {
            NormalDistribution n = (NormalDistribution)o;
            return this.mean == n.mean && this.variance == n.variance;
        }
        return false;
    }

    public double median() {
        return this.mean;
    }
}

