/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.morilib.awk.AwkExitException;
import net.morilib.awk.AwkNextException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkExpressionMachine
extends AwkExpression {
    static final int UNRESOLVED = -1;
    static final int JMP_END = Integer.MAX_VALUE;
    private Code[] codes;

    private AwkExpressionMachine(Code ... codes) {
        this.codes = codes;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles f) {
        Stack<Iterator<AwkValue>> st = new Stack<Iterator<AwkValue>>();
        AwkValue e = AwkUndefined.UNDEF;
        int pc = 0;
        while (pc < this.codes.length) {
            if (pc < 0) {
                throw new RuntimeException();
            }
            Code c = this.codes[pc];
            switch (c.mnemonic) {
                case COMP: {
                    e = c.expr.eval(ns, f);
                    ++pc;
                    break;
                }
                case JMP: {
                    pc = c.next;
                    break;
                }
                case JMP_Z: {
                    pc = !((AwkValue)e).toBoolean(ns) ? c.next : pc + 1;
                    break;
                }
                case JMP_NZ: {
                    pc = !((AwkValue)e).toBoolean(ns) ? pc + 1 : c.next;
                    break;
                }
                case PUSHIN: {
                    st.push(e.iterator());
                    ++pc;
                    break;
                }
                case GETIN: {
                    if (((Iterator)st.peek()).hasNext()) {
                        e = (AwkValue)((Iterator)st.peek()).next();
                        ns.assign(c.name, e);
                        ++pc;
                        break;
                    }
                    st.pop();
                    pc = c.next;
                    break;
                }
                case RETURN: {
                    return e;
                }
                case NEXT: {
                    throw new AwkNextException();
                }
                case EXIT: {
                    throw new AwkExitException(e);
                }
            }
        }
        return e;
    }

    /* synthetic */ AwkExpressionMachine(Code[] codeArray, AwkExpressionMachine awkExpressionMachine) {
        this(codeArray);
    }

    public static class Builder {
        private Map<Object, Integer> labels;
        private Map<Object, List<Code>> unresolved;
        private List<Code> codes = new ArrayList<Code>();

        public Builder() {
            this.labels = new HashMap<Object, Integer>();
            this.unresolved = new HashMap<Object, List<Code>>();
        }

        public void add(AwkExpression e) {
            this.codes.add(new Code(Mnemonic.COMP, e, this.codes.size()));
        }

        Code add(Mnemonic m, Object label) {
            Code d;
            if (label == null) {
                d = new Code(m, null, Integer.MAX_VALUE);
                this.codes.add(d);
            } else if (this.labels.containsKey(label)) {
                d = new Code(m, null, this.labels.get(label));
                this.codes.add(d);
            } else {
                d = new Code(m, null, -1);
                this.codes.add(d);
                List<Code> c = this.unresolved.get(label);
                if (c == null) {
                    c = new ArrayList<Code>();
                    this.unresolved.put(label, c);
                }
                c.add(d);
            }
            return d;
        }

        public void addReturn() {
            this.codes.add(new Code(Mnemonic.RETURN, null, 0));
        }

        public void addNext() {
            this.codes.add(new Code(Mnemonic.NEXT, null, 0));
        }

        public void addExit() {
            this.codes.add(new Code(Mnemonic.EXIT, null, 0));
        }

        public void addJmp(Object l) {
            this.add(Mnemonic.JMP, l);
        }

        public void addJmpZ(Object l) {
            this.add(Mnemonic.JMP_Z, l);
        }

        public void addJmpNZ(Object l) {
            this.add(Mnemonic.JMP_NZ, l);
        }

        public void addPushin() {
            this.codes.add(new Code(Mnemonic.PUSHIN, null, -1));
        }

        public void addGetin(String s, Object l) {
            this.add((Mnemonic)Mnemonic.GETIN, (Object)l).name = s;
        }

        public void addLabel(Object label) {
            int addr = this.codes.size();
            List<Code> c = this.unresolved.get(label);
            if (c != null) {
                for (Code d : c) {
                    d.next = addr;
                }
            }
            this.labels.put(label, addr);
        }

        public AwkExpression get() {
            return new AwkExpressionMachine(this.codes.toArray(new Code[0]), null);
        }
    }

    static class Code {
        Mnemonic mnemonic;
        AwkExpression expr;
        String name;
        int next;

        Code(Mnemonic m, AwkExpression e, String s, int n) {
            this.mnemonic = m;
            this.expr = e;
            this.next = n;
            this.name = s;
        }

        Code(Mnemonic m, AwkExpression e, int n) {
            this(m, e, null, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mnemonic {
        COMP,
        JMP,
        JMP_Z,
        JMP_NZ,
        PUSHIN,
        GETIN,
        RETURN,
        NEXT,
        EXIT;

    }
}

