/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkValue;

public class AwkComplex
extends AwkValue {
    private double real;
    private double imag;

    private AwkComplex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public static AwkValue valueOf(double real, double imag) {
        if (Double.isNaN(real) || Double.isNaN(imag)) {
            return AwkFloat.valueOf(Double.NaN);
        }
        if (imag == 0.0) {
            return AwkFloat.valueOf(real);
        }
        return new AwkComplex(real, imag);
    }

    public double toFloat() {
        return this.real;
    }

    public double toImaginary() {
        return this.imag;
    }

    public AwkValue toNumber() {
        return this;
    }

    public boolean isComplex() {
        return true;
    }

    public String toString(AwkNamespace ns) {
        if (this.imag > 0.0) {
            return String.valueOf(this.real) + "+" + this.imag + "i";
        }
        return String.valueOf(this.real) + this.imag + "i";
    }

    public boolean toBoolean(AwkNamespace ns) {
        return true;
    }

    public Object toObject() {
        return new double[]{this.real, this.imag};
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isIntegerValue() {
        return false;
    }

    public boolean isFloatValue() {
        return false;
    }

    public boolean isRealValue() {
        return false;
    }

    public boolean isPositiveValue() {
        return false;
    }

    public boolean isZeroValue() {
        return false;
    }

    public boolean isNegativeValue() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isRegex() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isNumber() {
        return true;
    }

    public int compareTo(AwkValue v, AwkNamespace ns) {
        throw new AwkCastException(this + " is not comparable");
    }
}

