/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedPatternEngine;
import net.morilib.sed.SedQuitException;
import net.morilib.sed.SedSpace;
import net.morilib.sed.cmd.SedCCommand;
import net.morilib.sed.cmd.SedLabel;
import net.morilib.sh.ShFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedEngine {
    private static Map<SedCommand, Map<SedLabel, Integer>> scopes = new HashMap<SedCommand, Map<SedLabel, Integer>>();

    private static synchronized Map<SedLabel, Integer> getscope(SedCommand c) {
        Map<SedLabel, Integer> m = scopes.get(c);
        if (m == null) {
            m = new HashMap<SedLabel, Integer>();
            scopes.put(c, m);
        }
        return m;
    }

    private static boolean match(SedLineOption m, SedSpace s, SedLineBuffer rd) {
        return m.matches(s.engine, s.toString(), rd.getLineNumber(), rd.isLastLine());
    }

    private static void out(ShFileSystem fs, SedSpace s, PrintStream pw, boolean display) throws IOException {
        BufferedReader rd = null;
        String v = s.toString();
        if (s.deleted) {
            return;
        }
        if (s.lineToInsert != null) {
            pw.println(s.lineToInsert);
        }
        if (display && v != null) {
            pw.println(v);
        }
        if (s.lineToAppend != null) {
            pw.println(s.lineToAppend);
        }
        s.printFileToWrite();
        if (s.fileToRead != null) {
            try {
                String t;
                rd = new BufferedReader(new InputStreamReader(fs.getFile(s.fileToRead).getInputStream()));
                while ((t = rd.readLine()) != null) {
                    pw.println(t);
                }
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
        }
    }

    private static int getip(Map<SedLabel, Integer> lb, SedLabel l, int ip, SedCommandLine ... lines) {
        int x = 0;
        if (l == null) {
            return ip;
        }
        if (!lb.containsKey(l)) {
            while (x < lines.length) {
                if (lines[x].command.equals(l)) break;
                ++x;
            }
            lb.put(l, x);
        } else {
            x = lb.get(l);
        }
        return x;
    }

    public static SedLabel execute(SedCommand cm, SedSpace sp, SedLineBuffer rd, SedCommandLine ... lines) throws IOException {
        Map<SedLabel, Integer> lb = SedEngine.getscope(cm);
        int ip = 0;
        while (ip < lines.length) {
            SedCommandLine l = lines[ip];
            if (SedEngine.match(l.matcher, sp, rd)) {
                l.command.process(sp, rd);
            }
            if (sp.deleted) {
                return null;
            }
            ip = SedEngine.getip(lb, sp.nextLabel, ip, lines);
            if (sp.nextLabel != null && ip >= lines.length) {
                return sp.nextLabel;
            }
            ++ip;
        }
        return null;
    }

    public static int execute(ShFileSystem fs, Reader reader, PrintStream pw, SedPatternEngine engine, boolean display, SedCommandLine ... lines) throws IOException {
        HashMap<SedLabel, Integer> lb = new HashMap<SedLabel, Integer>();
        SedLineBuffer rd = new SedLineBuffer(reader);
        boolean rt = true;
        SedSpace sp = new SedSpace(fs, engine, pw, display);
        try {
            String s;
            while ((s = rd.readLine()) != null) {
                block16: {
                    sp.setPatternSpace(s);
                    int ip = 0;
                    while (ip < lines.length) {
                        SedCommandLine l = lines[ip];
                        SedLineOption op = l.matcher;
                        boolean mt = SedEngine.match(op, sp, rd);
                        SedCommand cm = l.command;
                        if (cm instanceof SedCCommand && (mt || op.isMatching()) && !op.isNegate()) {
                            while (op.isMatching()) {
                                s = rd.readLine();
                                if (s == null) {
                                    if (display) {
                                        pw.println(((SedCCommand)cm).getString());
                                    }
                                    return 0;
                                }
                                sp.setPatternSpace(s);
                                SedEngine.match(op, sp, rd);
                            }
                            sp.clear();
                            sp.setPatternSpace(s);
                            if (display) {
                                pw.println(((SedCCommand)cm).getString());
                            }
                        } else {
                            if (mt) {
                                cm.process(sp, rd);
                            }
                            if (!sp.deleted) {
                                ip = SedEngine.getip(lb, sp.nextLabel, ip, lines);
                                sp.nextLabel = null;
                                ++ip;
                                continue;
                            }
                        }
                        break block16;
                    }
                    rt = sp.isSucceedBefore() | rt;
                    SedEngine.out(fs, sp, pw, display);
                }
                sp.clear();
            }
            int n = rt ? 0 : 1;
            return n;
        }
        catch (SedQuitException e) {
            SedEngine.out(fs, sp, pw, display);
            int n = e.exitCode;
            return n;
        }
        finally {
            pw.flush();
            sp.destroy();
        }
    }
}

