/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.diff.Change;
import net.morilib.diff.Diff;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShDiff
implements ShProcess {
    private static final Ot DFT = new OtD();

    private static String _ra(Change<?> c) {
        if (c.getBeginIndexA() == c.getEndIndexA()) {
            return Integer.toString(c.getBeginIndexA());
        }
        return String.format("%s,%s", c.getBeginIndexA(), c.getEndIndexA());
    }

    private static String _rb(Change<?> c) {
        if (c.getBeginIndexB() == c.getEndIndexB()) {
            return Integer.toString(c.getBeginIndexB());
        }
        return String.format("%s,%s", c.getBeginIndexB(), c.getEndIndexB());
    }

    List<String> _readall(BufferedReader rd, String eof) throws IOException {
        String s;
        ArrayList<String> l = new ArrayList<String>();
        while ((s = rd.readLine()) != null && !s.equals(eof)) {
            l.add(s);
        }
        return l;
    }

    void _diff(List<String> l, List<String> m, PrintStream out, Ot o) throws IOException {
        List<Change<String>> c = Diff.diff(l, m);
        o.out(l, m, c, out);
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        BufferedReader rd = null;
        String s = null;
        int k = 1;
        while (k < args.length) {
            if (args[k].equals("-c") || args[k].equals("--context")) {
                err.println("diff: context mode is not supported");
                return 2;
            }
            if (args[k].equals("-u") || args[k].equals("--unified")) {
                err.println("diff: unified mode is not supported");
                return 2;
            }
            if (args[k].equals("-e") || args[k].equals("--ed")) {
                err.println("diff: ed mode is not supported");
                return 2;
            }
            if (!args[k].startsWith("--haruka=") || args[k].length() <= 9) {
                if (args[k].equals("--")) {
                    ++k;
                    break;
                }
                if (args[k].equals("-") || !args[k].startsWith("-")) break;
                err.println("diff: invaild arguments");
                return 2;
            }
            s = args[k].substring(9);
            ++k;
        }
        if (s == null) {
            rd = new BufferedReader(new InputStreamReader(in, env.getCharset()));
            List<String> l = this._readall(rd, s);
            List<String> m = this._readall(rd, null);
            this._diff(l, m, out, DFT);
            return 0;
        }
        if (args.length - k >= 1) {
            try {
                rd = new BufferedReader(new InputStreamReader(fs.getFile(args[k++]).getInputStream(), env.getCharset()));
                List<String> l = this._readall(rd, null);
                rd.close();
                rd = new BufferedReader(new InputStreamReader(fs.getFile(args[k]).getInputStream(), env.getCharset()));
                List<String> m = this._readall(rd, null);
                this._diff(l, m, out, DFT);
                return 0;
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
        }
        err.println("diff: files must be specified");
        return 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Ot {
        private Ot() {
        }

        abstract void out(List<String> var1, List<String> var2, List<Change<String>> var3, PrintStream var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OtD
    extends Ot {
        private OtD() {
        }

        @Override
        void out(List<String> l1, List<String> l2, List<Change<String>> c, PrintStream out) {
            block5: for (Change<String> a : c) {
                switch (a.getOperation()) {
                    case 2: {
                        out.format("%da%s\n", a.getBeginIndexA(), ShDiff._rb(a));
                        for (String s : a.getAfter()) {
                            out.format("> %s\n", s);
                        }
                        continue block5;
                    }
                    case 3: {
                        out.format("%sd%d\n", ShDiff._ra(a), a.getBeginIndexB());
                        for (String s : a.getBefore()) {
                            out.format("< %s\n", s);
                        }
                        continue block5;
                    }
                    case 1: {
                        out.format("%sc%s\n", ShDiff._ra(a), ShDiff._rb(a));
                        for (String s : a.getBefore()) {
                            out.format("< %s\n", s);
                        }
                        out.println("---");
                        for (String s : a.getAfter()) {
                            out.format("> %s\n", s);
                        }
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        }
    }
}

