/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShRmdir
implements ShProcess {
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        boolean parent = false;
        int k = 1;
        int r = 0;
        if (args[k].equals("-p") || args[k].equals("--parent")) {
            parent = true;
            ++k;
        }
        int i = k;
        while (i < args.length) {
            if (args[i].length() == 0) {
                err.println("rmdir: an empty filename is forbidden.");
                r = 2;
            } else {
                ShFile f = fs.getFile(args[i]);
                if (!f.isDirectory()) {
                    err.print("rmdir: ");
                    err.print(args[i]);
                    err.println(" is not a directory.");
                    r = 2;
                } else if (!parent) {
                    if (!f.rmdir()) {
                        err.print("rmdir: ");
                        err.print(args[i]);
                        err.println(" is not empty");
                        r = 2;
                    }
                } else if (args[i].charAt(0) == '/') {
                    err.print("rmdir: absolute path with -p option ");
                    err.println("is forbidden.");
                    r = 2;
                } else {
                    String x = args[i];
                    while (x.length() > 0) {
                        f = fs.getFile(x = x.replaceFirst("/+$", ""));
                        if (!f.isDirectory()) {
                            err.print("rmdir: ");
                            err.print(args[i]);
                            err.println(" is not a directory.");
                            r = 2;
                        } else if (!f.rmdir()) {
                            err.print("rmdir: ");
                            err.print(x);
                            err.println(" is not empty");
                            r = 2;
                            break;
                        }
                        x = x.replaceFirst("[^/]+$", "");
                    }
                }
            }
            ++i;
        }
        return r;
    }
}

