/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileGetter;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.file.ShFileSystemFactory;
import net.morilib.unix.misc.OptionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShSort
implements ShProcess {
    private static final String STDIN = "(stdin)";
    private static final int MAX_FIELDS = 1000000;
    private static final Pattern OBS = Pattern.compile("\\+([0-9]+(\\.[0-9]*[1-9])?)");
    private static final Pattern OB2 = Pattern.compile("-([0-9]+)");
    private static final Pattern NEW = Pattern.compile("([0-9]*[1-9](\\.[0-9]*[1-9])?)(,([0-9]*[1-9]))?");
    private static final Pattern NUM = Pattern.compile("\\p{Space}*(-?)([0-9]*)\\.?");
    private static final Pattern SPC = Pattern.compile("\\p{Space}*");
    private static final Pattern ASP = Pattern.compile(" +");
    private static final Pattern POS = Pattern.compile("([0-9]+)(\\.([0-9]*[1-9]))?");
    private static final String ALS = "[^\\p{Alnum}\\p{Space}]+";
    private static final String ASC = "[^\\p{ASCII}]+";
    private static final int CHECK_SORTED = 1;
    private static final int MERGE = 2;
    private static final int IGNORE_SPACES = 4;
    private static final int USE_ALNUM_SPACES = 8;
    private static final int IGNORE_CASE = 16;
    private static final int USE_ASCII = 32;
    private static final int SORT_MONTHS = 64;
    private static final int SORT_NUMBERS = 128;
    private static final int REVERSE = 256;
    private static final int SUPPRESS_DUPLICATE = 512;

    private static void perror(PrintStream err, String n, String s) {
        err.print(n);
        err.print(": ");
        err.println(s);
    }

    private static int comparerev(String s, String t) {
        if (s.length() < t.length()) {
            return -1;
        }
        if (s.length() > t.length()) {
            return 1;
        }
        return s.compareTo(t);
    }

    private static int cmpstr(S1 f, String s1, String s2) {
        String s = s1;
        String t = s2;
        if ((f.flags & 4) != 0) {
            Matcher m = SPC.matcher(s);
            m.lookingAt();
            Matcher n = SPC.matcher(t);
            n.lookingAt();
            s = s.substring(m.end());
            t = t.substring(n.end());
        }
        if ((f.flags & 0x20) != 0) {
            s = s.replaceAll(ASC, "");
            t = t.replaceAll(ASC, "");
        }
        if ((f.flags & 8) != 0) {
            s = s.replaceAll(ALS, "");
            t = t.replaceAll(ALS, "");
        }
        int z = (f.flags & 0x10) != 0 ? s.compareToIgnoreCase(t) : s.compareTo(t);
        return (f.flags & 0x100) != 0 ? -z : z;
    }

    private static int cmpnum(S1 f, String s, String t) {
        int z;
        Matcher x = NUM.matcher(s);
        Matcher y = NUM.matcher(t);
        x.lookingAt();
        y.lookingAt();
        String a1 = x.group(1);
        String b1 = y.group(1);
        String a2 = x.group(2);
        String b2 = y.group(2);
        if (a1.equals("") && b1.equals("-")) {
            z = 1;
        } else if (a1.equals("-") && b1.equals("")) {
            z = -1;
        } else {
            z = ShSort.comparerev(a2, b2);
            if (z != 0) {
                z = a1.equals("-") ? -z : z;
            } else {
                s = s.substring(x.end());
                t = t.substring(y.end());
                z = ShSort.cmpstr(f, s, t);
            }
        }
        return (f.flags & 0x100) != 0 ? -z : z;
    }

    private static String[] _split(S1 f, String s) {
        ArrayList<String> l = new ArrayList<String>();
        int k = 0;
        if (f.sep == 32) {
            Matcher m = ASP.matcher(s);
            if (!m.lookingAt()) {
                m.reset();
            }
            while (m.find()) {
                l.add(s.substring(k, m.start()));
                k = m.end();
            }
            l.add(s.substring(k));
            return l.toArray(new String[0]);
        }
        return s.split("\\" + (char)f.sep);
    }

    private Comparator<String> getcmp(S1 f) {
        return (f.flags & 0x80) != 0 ? new CNum(f) : new CStr(f);
    }

    private S2 _pos1(String s) {
        S2 r = new S2(0, 0, 1000000);
        Matcher m = POS.matcher(s);
        m.matches();
        r.fs = Integer.parseInt(m.group(1));
        if (m.group(3) != null) {
            r.ch = Integer.parseInt(m.group(3));
        }
        return r;
    }

    private S2 _pos2(String s, String t) {
        Matcher m = POS.matcher(s);
        S2 r = new S2(0, 0, 0);
        m.matches();
        r.fs = Integer.parseInt(m.group(1)) - 1;
        int n = r.fe = t != null ? Integer.parseInt(t) : 1000000;
        if (m.group(3) != null) {
            r.ch = Integer.parseInt(m.group(3));
        }
        return r;
    }

    int _check(S1 f, InputStream in, String n, Charset cset) throws IOException {
        String t;
        Comparator<String> p = this.getcmp(f);
        String s = null;
        BufferedReader rd = new BufferedReader(new InputStreamReader(in, cset));
        while ((t = rd.readLine()) != null) {
            if (s != null && p.compare(s, t) > 0) {
                return 1;
            }
            s = t;
        }
        return 0;
    }

    boolean notnil(String[] ss) throws IOException {
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int _min(Comparator<String> p, String[] ss) {
        int k = 0;
        while (k < ss.length && ss[k] == null) {
            ++k;
        }
        int i = k + 1;
        while (i < ss.length) {
            if (ss[i] != null) {
                k = p.compare(ss[k], ss[i]) > 0 ? i : k;
            }
            ++i;
        }
        return k;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int _merge(S1 f, ShFileSystem fs, PrintStream out, Charset cset, String ... fls) throws IOException {
        rs = new BufferedReader[fls.length];
        ss = new String[fls.length];
        p = this.getcmp(f);
        Arrays.fill(rs, null);
        try {
            i = 0;
            while (i < fls.length) {
                rs[i] = new BufferedReader(new InputStreamReader(fs.getFile(fls[i]).getInputStream(), cset));
                ss[i] = rs[i].readLine();
                ++i;
            }
            while (this.notnil(ss)) {
                z = this._min(p, ss);
                out.println(ss[z]);
                ss[z] = rs[z].readLine();
            }
        }
        finally {
            i = 0;
            ** while (i < fls.length)
        }
lbl-1000:
        // 1 sources

        {
            if (rs[i] != null) {
                rs[i].close();
            }
            ++i;
            continue;
        }
lbl25:
        // 1 sources

        return 0;
    }

    int _sort(S1 f, List<String> l, InputStream in, String n, Charset cset) throws IOException {
        String t;
        if ((f.flags & 1) != 0) {
            return this._check(f, in, n, cset);
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(in, cset));
        while ((t = rd.readLine()) != null) {
            l.add(t);
        }
        return 0;
    }

    void _execsort(S1 f, List<String> l, PrintStream out) {
        Comparator<String> p = this.getcmp(f);
        String[] a = l.toArray(new String[0]);
        Arrays.sort(a, p);
        int i = 0;
        while (i < a.length) {
            if ((f.flags & 0x200) == 0 || i == 0 || p.compare(a[i - 1], a[i]) != 0) {
                out.println(a[i]);
            }
            ++i;
        }
    }

    int main(ShEnvironment env, ShFileSystem fs, ShFileGetter gt, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        String s;
        Charset cset = env.getCharset();
        InputStream ins = null;
        PrintStream ous = out;
        S1 f = new S1();
        OptionIterator o = new OptionIterator("1234567890.cmut:o:bdfiMnrk:", true, args);
        block24: while (o.hasNext()) {
            s = o.getLookahead();
            Matcher m = OBS.matcher(s);
            if (m.matches()) {
                f.fields.add(this._pos1(m.group(1)));
                o.skip();
                continue;
            }
            m = OB2.matcher(s);
            if (m.matches()) {
                if (f.fields.size() > 0) {
                    ((S2)((S1)f).fields.get((int)(((S1)f).fields.size() - 1))).fe = Integer.parseInt(m.group(1));
                } else {
                    f.fields.add(new S2(0, 0, Integer.parseInt(m.group(1))));
                }
                o.skip();
                continue;
            }
            switch (o.nextChar()) {
                case 'c': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 1;
                    break;
                }
                case 'm': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 2;
                    break;
                }
                case 'u': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 0x200;
                    break;
                }
                case 't': {
                    if (o.getArgument().length() <= 0) continue block24;
                    f.sep = o.getArgument().charAt(0);
                    break;
                }
                case 'o': {
                    f.ofile = o.getArgument();
                    break;
                }
                case 'b': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 4;
                    break;
                }
                case 'd': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 8;
                    break;
                }
                case 'f': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 0x10;
                    break;
                }
                case 'i': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 0x20;
                    break;
                }
                case 'M': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 0x40;
                    err.print(args[0]);
                    err.print(": warning: ");
                    err.print("option M is not supported");
                    err.println(" in this version.");
                    break;
                }
                case 'n': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 0x80;
                    break;
                }
                case 'r': {
                    S1 s1 = f;
                    s1.flags = s1.flags | 0x100;
                    break;
                }
                case 'k': {
                    m = NEW.matcher(o.getArgument());
                    if (!m.matches()) {
                        ShSort.perror(err, args[0], "invalid field");
                        return 2;
                    }
                    S2 x = this._pos2(m.group(1), m.group(4));
                    f.fields.add(x);
                    if (x.fs < x.fe) continue block24;
                    ShSort.perror(err, args[0], "invalid field");
                    return 2;
                }
                default: {
                    ShSort.perror(err, args[0], "invalid argument");
                    return 2;
                }
            }
        }
        try {
            int z;
            if (f.ofile != null) {
                ous = fs.getFile(f.ofile).getPrintStream(false);
            }
            if (f.fields.isEmpty()) {
                f.fields.add(new S2(0, 0, 1000000));
            }
            ArrayList<String> l = new ArrayList<String>();
            Iterator<String> q = o.filenameIterator();
            if (!q.hasNext()) {
                z = this._sort(f, l, in, STDIN, cset);
                if (z != 0) {
                    int n = z;
                    return n;
                }
            } else {
                if ((f.flags & 2) != 0) {
                    l = new ArrayList();
                    while (q.hasNext()) {
                        l.add(q.next());
                    }
                    int n = this._merge(f, fs, ous, cset, l.toArray(new String[0]));
                    return n;
                }
                z = 0;
                while (q.hasNext()) {
                    s = q.next();
                    if (s.equals("-")) {
                        z = this._sort(f, l, in, STDIN, cset);
                    } else {
                        try {
                            ins = fs.getFile(s).getInputStream();
                            z = this._sort(f, l, ins, s, cset);
                        }
                        finally {
                            if (ins != null) {
                                ins.close();
                            }
                            ins = null;
                        }
                    }
                    if (z == 0) continue;
                    int n = z;
                    return n;
                }
            }
            this._execsort(f, l, out);
            int n = z;
            return n;
        }
        finally {
            if (ous != out) {
                ous.close();
            }
        }
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        String[] a = new String[args.length - 1];
        System.arraycopy(args, 1, a, 0, a.length);
        return this.main(env, fs, ShFileGetter.SH_FILE, in, out, err, a);
    }

    public static void main(String[] args) {
        try {
            System.exit(new ShSort().main(ShFileSystemFactory.getSystemEnvironment(), ShFileSystemFactory.getInstance(), ShFileGetter.SH_NATIVE, System.in, System.out, System.err, args));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CNum
    implements Comparator<String> {
        private S1 f;

        CNum(S1 f) {
            this.f = f;
        }

        @Override
        public int compare(String s, String t) {
            String[] a = ShSort._split(this.f, s);
            String[] b = ShSort._split(this.f, t);
            block0: for (S2 x : this.f.fields) {
                int i = x.fs;
                while (i < x.fe) {
                    String w;
                    String v;
                    if (i >= a.length && i >= b.length) continue block0;
                    if (i < a.length && i >= b.length) {
                        return 1;
                    }
                    if (i >= a.length && i < b.length) {
                        return -1;
                    }
                    if (x.ch > 0) {
                        v = x.ch < a[i].length() ? a[i].substring(0, x.ch) : a[i];
                        w = x.ch < b[i].length() ? b[i].substring(0, x.ch) : b[i];
                    } else {
                        v = a[i];
                        w = b[i];
                    }
                    int r = ShSort.cmpnum(this.f, v, w);
                    if (r != 0) {
                        return r;
                    }
                    ++i;
                }
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CStr
    implements Comparator<String> {
        private S1 f;

        CStr(S1 f) {
            this.f = f;
        }

        @Override
        public int compare(String s, String t) {
            String[] a = ShSort._split(this.f, s);
            String[] b = ShSort._split(this.f, t);
            block0: for (S2 x : this.f.fields) {
                int i = x.fs;
                while (i < x.fe) {
                    String w;
                    String v;
                    if (i >= a.length && i >= b.length) continue block0;
                    if (i < a.length && i >= b.length) {
                        return 1;
                    }
                    if (i >= a.length && i < b.length) {
                        return -1;
                    }
                    if (x.ch > 0) {
                        v = x.ch < a[i].length() ? a[i].substring(0, x.ch) : a[i];
                        w = x.ch < b[i].length() ? b[i].substring(0, x.ch) : b[i];
                    } else {
                        v = a[i];
                        w = b[i];
                    }
                    int r = ShSort.cmpstr(this.f, v, w);
                    if (r != 0) {
                        return r;
                    }
                    ++i;
                }
            }
            return 0;
        }
    }

    private static class S1 {
        private int flags;
        private List<S2> fields = new ArrayList<S2>();
        private String ofile = null;
        private int sep = 32;

        private S1() {
        }
    }

    private static class S2 {
        int fs;
        int ch;
        int fe;

        S2(int fs, int ch, int fe) {
            this.fs = fs;
            this.ch = ch;
            this.fe = fe;
        }
    }
}

