/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.file.ShRealFile;

public class ShOSProcess
implements ShProcess {
    private static final int BUFSIZE = 1024;
    private ShRealFile command;

    ShOSProcess(ShRealFile command) {
        this.command = command;
    }

    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
        Thread ot = null;
        Thread er = null;
        InThread0 in = null;
        try {
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(args));
            l.set(0, this.command.file.toString());
            ProcessBuilder b = new ProcessBuilder(l);
            Process p = b.start();
            in = new InThread3(stdin, p.getOutputStream());
            ot = new InThread1(p.getInputStream(), stdout);
            er = new InThread1(p.getErrorStream(), stderr);
            in.start();
            ot.start();
            er.start();
            int n = p.waitFor();
            return n;
        }
        catch (BException ex) {
            throw ex.ioex;
        }
        catch (InterruptedException e) {
            return 255;
        }
        finally {
            try {
                if (in != null) {
                    in.setStop();
                    in.join();
                }
                if (ot != null) {
                    ot.join();
                }
                if (er != null) {
                    er.join();
                }
                stdout.flush();
                stderr.flush();
            }
            catch (InterruptedException e) {
                return 255;
            }
        }
    }

    static class BException
    extends RuntimeException {
        IOException ioex;

        public BException(IOException t) {
            this.ioex = t;
        }
    }

    static abstract class InThread0
    extends Thread {
        InputStream src;
        OutputStream dest;
        boolean live = true;

        InThread0(InputStream src, OutputStream dest) {
            this.src = src;
            this.dest = dest;
        }

        synchronized void setStop() {
            this.live = false;
        }
    }

    static class InThread1
    extends InThread0 {
        InThread1(InputStream src, OutputStream dest) {
            super(src, dest);
        }

        public void run() {
            byte[] b = new byte[1024];
            try {
                int l;
                while ((l = this.src.read(b)) >= 0) {
                    this.dest.write(b, 0, l);
                    this.dest.flush();
                }
            }
            catch (IOException e) {
                throw new BException(e);
            }
        }
    }

    static class InThread3
    extends InThread0 {
        InThread3(InputStream src, OutputStream dest) {
            super(src, dest);
        }

        public void run() {
            try {
                while (this.live) {
                    int c;
                    while (this.live && this.src.available() == 0) {
                    }
                    if (!this.live || (c = this.src.read()) < 0) {
                        return;
                    }
                    this.dest.write(c);
                    this.dest.flush();
                }
            }
            catch (IOException e) {
                throw new BException(e);
            }
        }
    }
}

