/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.File;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.file.ShOSProcess;
import net.morilib.sh.file.ShRealFile;
import net.morilib.sh.misc.FileTypeUtils;

public class ShUnixRealFile
extends ShRealFile {
    public ShUnixRealFile(ShFileSystem fs, String virtualpath, File file) {
        super(fs, virtualpath, file);
    }

    public ShProcess getProcess() {
        if (FileTypeUtils.guessUnixExecutable(this.file).isExecutable()) {
            if (this.filesystem.getSecurityPolicy().denyExecuteOSCommand()) {
                return null;
            }
            return new ShOSProcess(this);
        }
        String[] a = FileTypeUtils.parseShebang(this.file);
        if (a != null && a[1].equals("jsh")) {
            return null;
        }
        if (a != null && a[0] != null && a[1] != null) {
            return null;
        }
        return null;
    }

    public boolean isExecutable() {
        return this.file.canExecute();
    }
}

