/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.file.AbstractShEnvironment;
import net.morilib.sh.file.ShWindowsFileSystem;

public class ShWindowsEnvironment
extends AbstractShEnvironment {
    private Map<String, String> map;
    private Map<String, ShEnvironment.Attributes> attrs;

    ShWindowsEnvironment(ShFileSystem fs) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuffer b = new StringBuffer();
        String d = "";
        this.attrs = new HashMap<String, ShEnvironment.Attributes>();
        try {
            this.map = new HashMap<String, String>(System.getenv());
            String s = this.map.get("Path");
            if (s != null) {
                this.map.remove("Path");
                this.map.put("PATH", s);
            }
            if ((s = this.find("PATH")) != null) {
                String[] a;
                String[] stringArray = a = s.split(";+");
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    ShFile f = fs.getNativeFile(t);
                    l.add(f.toString());
                    b.append(d).append(f.toString());
                    d = ":";
                    ++n2;
                }
                this.map.put("PATH", b.toString());
            }
            this.path = l;
            if (this.map.containsKey("HOMEDRIVE") && this.map.containsKey("HOMEPATH")) {
                this.map.put("HOME", ShWindowsFileSystem.toJshFilename(String.valueOf(this.map.get("HOMEDRIVE")) + this.map.get("HOMEPATH")));
            }
        }
        catch (SecurityException e) {
            this.map = new HashMap<String, String>();
        }
    }

    public void bind(String name, String value) {
        this.map.put(name, value);
        this.setpath();
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public String find(String name) {
        return this.map.containsKey(name) ? this.map.get(name) : "";
    }

    public ShEnvironment getEnvironment() {
        return null;
    }

    public void put(String name, String value) {
        this.map.put(name, value);
    }

    public Properties toProperties() {
        Properties r = new Properties();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            r.setProperty(e.getKey(), e.getValue());
        }
        return r;
    }

    public void export(String name) {
        this.map.put(name, "");
    }

    public void unbind(String name) {
        this.map.remove(name);
    }

    public boolean isReadonly(String name) {
        ShEnvironment.Attributes a = this.attrs.get(name);
        return a != null && a.isReadonly();
    }

    public void setReadonly(String name) {
        if (this.map.containsKey(name)) {
            this.attrs.put(name, READONLY);
        }
    }
}

