/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

import java.util.HashMap;
import java.util.Map;

/**
 * Cプリプロセッサの文字列リテラルです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreStringToken extends CpreToken {

	private String name;

	private static Map<String, CpreStringToken> vars =
		new HashMap<String, CpreStringToken>();

	private CpreStringToken(String name) {
		super("\"" + name + "\"");
		this.name = name;
	}

	/**
	 * 文字列リテラルを取得します。
	 * 
	 * @param name 文字列
	 * @return リテラル
	 */
	public static CpreStringToken getInstance(String name) {
		CpreStringToken v;

		if((v = vars.get(name)) == null) {
			vars.put(name, v = new CpreStringToken(name));
		}
		return v;
	}

	public String getString() {
		return name;
	}

}
