/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.misc;

import java.io.OutputStream;
import java.io.PrintStream;

public class XtraceStream extends PrintStream {

	private int level = 0;

	public XtraceStream(OutputStream out) {
		super(out);
	}

	public int upLevel() {
		return ++level;
	}

	public int downLevel() {
		return level > 0 ? --level : level;
	}

	public void printPrompt(String s) {
		char c;

		s = (s == null || s.equals("")) ? "+ " : s;
		c = s.charAt(0);
		for(int i = 0; i < level; i++)  print(c);
		print(s);
	}

}
