/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

/**
 * 代入演算子のトークンです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkAssignop extends AwkOperator {

	/**
	 * 単純代入です。
	 */
	public static final AwkOperator ASSIGN = new AwkAssignop("=");

	/**
	 * 加算代入です。
	 */
	public static final AwkOperator A_ADD = new AwkAssignop("+=");

	/**
	 * 減算代入です。
	 */
	public static final AwkOperator A_SUB = new AwkAssignop("-=");

	/**
	 * 乗算代入です。
	 */
	public static final AwkOperator A_MUL = new AwkAssignop("*=");

	/**
	 * 除算代入です。
	 */
	public static final AwkOperator A_DIV = new AwkAssignop("/=");

	/**
	 * 剰余代入です。
	 */
	public static final AwkOperator A_MOD = new AwkAssignop("%=");

	/**
	 * べき乗代入です。
	 */
	public static final AwkOperator A_POW = new AwkAssignop("^=");
//	public static final AwkOperator A_B_AND = new AwkAssignop("&=");
//	public static final AwkOperator A_B_OR  = new AwkAssignop("|=");

	AwkAssignop(String desc) {
		super(desc, 90);
	}

}
